% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_align_start_end}
\alias{mt_align_start_end}
\title{Align start and end position of trajectories.}
\usage{
mt_align_start_end(
  data,
  use = "trajectories",
  save_as = use,
  dimensions = c("xpos", "ypos"),
  start = c(0, 0),
  end = c(-1, 1),
  verbose = FALSE
)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{dimensions}{a character vector specifying the dimensions in the
trajectory array that should be aligned.}

\item{start}{a numeric vector specifying the start values for each dimension,
i.e., the values the first recorded position should have in every trial. If
\code{NULL}, trajectories are aligned to the mean first position across all
trials.}

\item{end}{a numeric vector specifying the end values for each dimension,
i.e., the values the last recorded position should have in every trial. If
\code{NULL}, trajectories are aligned to the mean last position across all
trials. Note that in this case trajectories should be remapped to one side
before alignment (e.g., using \link{mt_remap_symmetric}) so that the mean
last position is meaningful.}

\item{verbose}{logical indicating whether function should report its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with aligned
trajectories. All other trajectory dimensions not specified in
\code{dimensions} (e.g., timestamps) will be kept as is in the resulting
trajectory array. If the trajectory array was provided directly as
\code{data}, only the trajectory array will be returned.
}
\description{
Adjust trajectories so that all trajectories have an identical start and end
point. In some articles, this is also referred to as space-normalization
(e.g. Dale et al., 2007).
}
\examples{
# Align start and end positions to specific coordinates
mt_example <- mt_align_start_end(mt_example,
  start=c(0,0), end=c(-1,1))
  
  
# Import raw trajectories for demonstration
mt_example <- mt_import_mousetrap(mt_example_raw)

# Remap trajectories
mt_example <- mt_remap_symmetric(mt_example)

# Align trajectories to mean first and last coordinates
mt_example <- mt_align_start_end(mt_example,
  start=NULL, end=NULL)

  
}
\references{
Dale, R., Kehoe, C., & Spivey, M. J. (2007). Graded motor
responses in the time course of categorizing atypical exemplars.
\emph{Memory & Cognition, 35}(1), 15-28.
}
\seealso{
\link{mt_align_start} for aligning the start position of
trajectories.

\link{mt_align} as a general purpose function for aligning and rescaling
trajectories.

\link{mt_remap_symmetric} for remapping trajectories.
}
\author{
Pascal J. Kieslich

Felix Henninger
}
