% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth.R
\name{bandwidths.default}
\alias{bandwidths.default}
\title{Default choice of multiple bandwidth set}
\usage{
bandwidths.default(n, d.min = 10, G.min = 8, G.max = 3 * sqrt(n))
}
\arguments{
\item{n}{integer representing the sample size}

\item{d.min}{integer for the minimal mutual distance of change points that can be expected}

\item{G.min}{integer for the minimal allowed bandwidth}

\item{G.max}{integer for the maximal allowed bandwidth}
}
\value{
an integer vector of bandwidths
}
\description{
Create bandwidths according to a default formula of the sample size
}
\details{
Returns an integer vector of bandwidths (G_1,...,G_m), 
with G_0 = G_1 = max(G.min, 2/3*d.min), and G_{j+1} = G_{j-1} + G_j (for j=1,...,m-1)
and m such that G_m <= G.max.
}
