% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{vectors}
\alias{vectors}
\alias{\%dot\%}
\alias{\%onto\%}
\alias{\%perp\%}
\alias{normalize}
\alias{as_magnitude}
\title{Utilities for vector calculations}
\usage{
u \%dot\% b

b \%onto\% A

b \%perp\% A

normalize(A)

as_magnitude(A, metric = c("2", "O", "I", "F", "M"))
}
\arguments{
\item{u}{a row vector, but a column vector is acceptable too}

\item{b}{a column vector}

\item{A}{a matrix}

\item{metric}{metric to use for matrix norm}
}
\value{
either a number (for \verb{\%dot\%}) or a vector
}
\description{
\verb{\%dot\%}, \verb{\%onto\%}, and \verb{\%perp\%} are infix operators.
The left-hand argument is a vector.
}
\details{
Convenience functions for basic operations relating to vector projection. These use
the \emph{MOSAIC Calc} conventions that require vectors to be one column matrices.
}
