% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survFitTT.R
\name{summary.survFitTT}
\alias{summary.survFitTT}
\title{Summary of \code{survFitTT} object}
\usage{
\method{summary}{survFitTT}(object, quiet = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{survFitTT}}

\item{quiet}{when \code{TRUE}, does not print}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns a list with the following information:
\item{Qpriors}{quantiles of the model priors}
\item{Qposteriors}{quantiles of the model posteriors}
\item{QLCx}{quantiles of LCx estimates}
}
\description{
This is the generic \code{summary} S3 method for the \code{survFitTT} class.
It shows the quantiles of priors and posteriors on parameters and the quantiles
of the posteriors on the LCx estimates.
}
\examples{
# (1) Load the data
data(cadmium1)

# (2) Create a survData object
cadmium1 <- survData(cadmium1)

\dontrun{
# (3) Run the survFitTT function with the log-logistic
# binomial model
out <- survFitTT(cadmium1, lcx = c(5, 10, 15, 20, 30, 50, 80),
                 quiet = TRUE)

# (4) summarize the survFitTT object
summary(out)
}

}
\keyword{summary}
