% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survDataVarExp.R
\name{summary.survDataVarExp}
\alias{summary.survDataVarExp}
\title{Summary of \code{survDataVarExp} object}
\usage{
\method{summary}{survDataVarExp}(object, quiet = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{survDataVarExp}}

\item{quiet}{when \code{TRUE}, does not print}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns a list with the following information:
\item{OccRepTime}{Occurence of replicates for all time points}
\item{NbsurvTimeRep}{nb of survivors. for all replicates and time points}
\item{ConcTimeRep}{Concentration for all replicates and time points}
}
\description{
The generic \code{summary} S3 method for the \code{survDataVarExp} class provides
information about the structure of the dataset and the experimental design.
}
\examples{
# (1) Load the data
data(propiconazole_pulse_exposure)

# (2) Create a survDataVarExp object
out <- survData(propiconazole_pulse_exposure)

# (3) Summarize the dataset
summary(out)

}
\keyword{summary}
