% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morse.R
\docType{data}
\name{propiconazole}
\alias{propiconazole}
\title{Survival dataset for \emph{Gammarus pulex} exposed to propiconazole
during four days}
\format{A dataframe with 75 observations on the following four variables:
\describe{ \item{\code{replicate}}{A vector of class \code{factor} with the
replicate code (\code{SC} for the control and \code{A1} to \code{G2} for other profiles).}
\item{\code{conc}}{A vector of class \code{numeric} with propiconazole
concentrations in \eqn{\mu mol.L^{-1}}.}
\item{\code{time}}{A vector of class \code{integer} with the time points
(in days from the beginning of the experiment \eqn{t = 0}).}
\item{\code{Nsurv}}{A vector of class \code{integer} with the number of
alive individuals at each time point for each concentration and each
replicate.}}}
\usage{
data(propiconazole)
}
\description{
Survival dataset of chronic laboratory toxicity tests with
\emph{Gammarus pulex} freshwater invertebrate exposed to eight concentrations
of one fungicide (propiconazole) during four days. Eight
concentrations were tested with two replicates of 10 organisms per concentration.
Survival is monitored at five time points.
}
\references{
Nyman, A.-M., Schirmer, K., Ashauer, R., (2012) Toxicokinetic-toxicodynamic
modelling of survival of \emph{Gammarus pulex} in multiple pulse exposures to
propiconazole: model assumptions, calibration data requirements and predictive
power, \emph{Ecotoxicology}, (21), 1828-1840.
}
\keyword{dataset}
