% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{read_question_excel}
\alias{read_question_excel}
\title{Read a question Excel file}
\usage{
read_question_excel(file, sheet_index = NULL, sheet_name = NULL)
}
\arguments{
\item{file}{A string, name of a text file.}

\item{sheet_index}{A number, sheet index in the workbook.}

\item{sheet_name}{A string, sheet name.}
}
\value{
A data frame.
}
\description{
Reads an Excel file of questions and returns a data frame.
}
\details{
In addition to the file, we can indicate the sheet by its name or index. If we
do not indicate anything, it considers the first sheet.
}
\examples{

\donttest{
file <- system.file("extdata", "questions.xlsx", package = "moodef")
df <- read_question_excel(file = file)
}

}
\seealso{
Other support functions: 
\code{\link{create_question_csv}()},
\code{\link{create_question_data_frame}()},
\code{\link{create_question_excel}()},
\code{\link{read_question_csv}()},
\code{\link{vector_to_string}()}
}
\concept{support functions}
