% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\title{Normalise points}
\usage{
normalise(x, to_range = c(1, 2), lower = NA, upper = NA, maximise = FALSE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{to_range}{\code{numerical(2)}\cr Normalise values to this range. If the objective is
maximised, it is normalised to \code{c(to_range[1], to_range[0])}
instead.}

\item{lower, upper}{\code{numerical()}\cr Bounds on the values. If \code{NA}, the maximum and minimum
values of each coordinate are used.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}
}
\value{
\code{matrix()}\cr A numerical matrix
}
\description{
Normalise points per coordinate to a range, e.g., \code{c(1,2)}, where the
minimum value will correspond to 1 and the maximum to 2. If bounds are
given, they are used for the normalisation.
}
\examples{

data(SPEA2minstoptimeRichmond)
# The second objective must be maximized
head(SPEA2minstoptimeRichmond[, 1:2])

head(normalise(SPEA2minstoptimeRichmond[, 1:2], maximise = c(FALSE, TRUE)))

head(normalise(SPEA2minstoptimeRichmond[, 1:2], to_range = c(0,1), maximise = c(FALSE, TRUE)))

}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
