% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_WOE_BINNING.R
\name{woe.bin}
\alias{woe.bin}
\title{Four-stage monotonic binning procedure with WoE threshold}
\usage{
woe.bin(
  x,
  y,
  sc = c(NA, NaN, Inf),
  sc.method = "together",
  y.type = NA,
  min.pct.obs = 0.05,
  min.avg.rate = 0.01,
  woe.gap = 0.1,
  force.trend = NA
)
}
\arguments{
\item{x}{Numeric vector to be binned.}

\item{y}{Numeric target vector (binary or continuous).}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf)}.
Recommendation is to keep the default values always and add new ones if needed. Otherwise, if these values exist
in \code{x} and are not defined in the \code{sc} vector, function will report the error.}

\item{sc.method}{Define how special cases will be treated, all together or in separate bins.
Possible values are \code{"together", "separately"}.}

\item{y.type}{Type of \code{y}, possible options are \code{"bina"} (binary) and \code{"cont"} (continuous).
If default value (\code{NA}) is passed, then algorithm will identify if \code{y} is 0/1 or continuous variable.}

\item{min.pct.obs}{Minimum percentage of observations per bin. Default is 0.05 or minimum 30 observations.}

\item{min.avg.rate}{Minimum \code{y} average rate. Default is 0.01 or minimum 1 bad case for y 0/1.}

\item{woe.gap}{Minimum WoE gap between bins. Default is 0.1.}

\item{force.trend}{If the expected trend should be forced. Possible values: \code{"i"} for
increasing trend (\code{y} increases with increase of \code{x}), \code{"d"} for decreasing trend
(\code{y} decreases with decrease of \code{x}). Default value is \code{NA}.
If the default value is passed, then trend will be identified based on the sign of the Spearman correlation
coefficient between \code{x} and \code{y} on complete cases.}
}
\value{
The command \code{woe.bin} generates a list of two objects. The first object, data frame \code{summary.tbl}
presents a summary table of final binning, while \code{x.trans} is a vector of discretized values.
In case of single unique value for \code{x} or \code{y} of complete cases (cases different than special cases),
it will return data frame with info.
}
\description{
\code{woe.bin} implements extension of the three-stage monotonic binning procedure (\code{\link{iso.bin}})
with weights of evidence (WoE) threshold.
The first stage is isotonic regression used to achieve the monotonicity. The next two stages are possible corrections for
minimum percentage of observations and target rate, while the last stage is iterative merging of
bins until WoE threshold is exceeded.
}
\examples{
suppressMessages(library(monobin))
data(gcd)
amount.bin <- woe.bin(x = gcd$amount, y = gcd$qual)
amount.bin[[1]]
diff(amount.bin[[1]]$woe)
tapply(gcd$amount, amount.bin[[2]], function(x) c(length(x), mean(x)))
woe.bin(x = gcd$maturity, y = gcd$qual)[[1]]
woe.bin(x = gcd$maturity, y = gcd$qual, woe.gap = 0.5)[[1]]

}
\seealso{
\code{\link{iso.bin}} for three-stage monotonic binning procedure.
}
