% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialCov.R
\name{plotSpatialCov}
\alias{plotSpatialCov}
\title{Plot observations on raster image}
\usage{
plotSpatialCov(
  data,
  spatialCov,
  segments = TRUE,
  compact = TRUE,
  col = NULL,
  alpha = 1,
  size = 1,
  shape = 16,
  states = NULL,
  animals = NULL,
  ask = TRUE,
  return = FALSE,
  stateNames = NULL
)
}
\arguments{
\item{data}{Data frame or \code{\link{momentuHMMData}} object, with necessary fields 'x' (longitudinal direction) and 'y' (latitudinal direction).  A \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object is also permitted, from which the data will be extracted.
If \code{states=NULL} and a \code{momentuHMM}, \code{miHMM}, or \code{miSum} object is provided, the decoded states are automatically plotted.}

\item{spatialCov}{\code{\link[raster]{raster}} object of the \code{RasterLayer} class on which to plot the location data}

\item{segments}{\code{TRUE} if segments should be plotted between the observations (default),
\code{FALSE} otherwise.}

\item{compact}{\code{FALSE} if tracks should be plotted separately, \code{TRUE}
otherwise (default).}

\item{col}{Palette of colours to use for the dots and segments. If not specified, uses default palette.}

\item{alpha}{Transparency argument for \code{\link[ggplot2]{geom_point}}.}

\item{size}{Size argument for \code{\link[ggplot2]{geom_point}}.}

\item{shape}{Shape argument for \code{\link[ggplot2]{geom_point}}. If \code{states} is provided, then \code{shape} must either be a scalar or a vector of length \code{length(unique(states))}.
If \code{states=NULL}, then \code{shape} must either be a scalar or a vector consisting of a value for each individual to be plotted.}

\item{states}{A sequence of integers, corresponding to the decoded states for these data. If
specified, the observations are colored by states.}

\item{animals}{Vector of indices or IDs of animals/tracks to be plotted.
Default: \code{NULL}; all animals are plotted.}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{return}{If \code{TRUE}, the function returns a ggplot object (which can be edited and
plotted manually). If \code{FALSE}, the function automatically plots the map (default).}

\item{stateNames}{Optional character vector of length \code{max(states)} indicating state names. Ignored unless \code{states} is provided.}
}
\description{
Plot tracking data over a raster layer.
}
\examples{
\dontrun{
stepDist <- "gamma"
angleDist <- "vm"

# plot simulated data over forest raster automatically loaded with the packge
spatialCov<-list(forest=forest)
data <- simData(nbAnimals=2,nbStates=2,dist=list(step=stepDist,angle=angleDist),
                Par=list(step=c(100,1000,50,100),angle=c(0,0,0.1,5)),
                beta=matrix(c(5,-10,-25,50),nrow=2,ncol=2,byrow=TRUE),
                formula=~forest,spatialCovs=spatialCov,
                obsPerAnimal=225,states=TRUE)

plotSpatialCov(data,forest,states=data$states)
}
}
