% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_miSum.R
\name{print.miSum}
\alias{print.miSum}
\title{Print \code{miSum}}
\usage{
\method{print}{miSum}(x, ...)
}
\arguments{
\item{x}{A \code{miSum} object.}

\item{...}{Currently unused. For compatibility with generic method.}
}
\description{
Print \code{miSum}
}
\examples{
\dontshow{
set.seed(2,kind="Mersenne-Twister",normal.kind="Inversion")
}
\dontrun{
# Extract data from miExample
obsData <- miExample$obsData

# error ellipse model
err.model <- list(x= ~ ln.sd.x - 1, y =  ~ ln.sd.y - 1, rho =  ~ error.corr)

# Fit crawl to obsData
crwOut <- crawlWrap(obsData,theta=c(4,0),fixPar=c(1,1,NA,NA),
                    err.model=err.model)
                    
# Fit four imputations
bPar <- miExample$bPar
HMMfits <- MIfitHMM(crwOut,nSims=4,poolEstimates=FALSE,
                   nbStates=2,dist=list(step="gamma",angle="vm"),
                   Par0=bPar$Par,beta0=bPar$beta,
                   formula=~cov1+cos(cov2),
                   estAngleMean=list(angle=TRUE),
                   covNames=c("cov1","cov2"))
                   
# Pool estimates
miSum <- MIpool(HMMfits)
print(miSum)
}
}
