% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARC3d.R
\name{ARC3d}
\alias{ARC3d}
\title{Plot Area Relative Curvature on Tooth Mesh}
\usage{
ARC3d(
  ARC_object,
  main = "",
  cex.main = 2,
  cex = 1,
  colors = c("darkblue", "blue", "powderblue", "gray", "gray", "tan", "orange",
    "darkorange1"),
  fieldofview = 0,
  legend = T
)
}
\arguments{
\item{ARC_object}{An object that stores the output of the \code{ARC()}
function}

\item{main}{string indicating plot title. Defaults to empty}

\item{cex.main}{numeric value setting the relative size of the plot title,}

\item{cex}{numeric value setting the relative size of the legend, default=1}

\item{colors}{a concatenated string of colors for plotting different values of
positive and negative curvature.}

\item{fieldofview}{Passes an argument to \code{par3d()} changing the field of
view (in degrees) of the resulting 3D plot}

\item{legend}{Logical indicating whether or not a legend
shold be displayed. Default=T}
}
\description{
a molaR surface plotting function
}
\details{
This function creates a surface map of the discarded DNE faces.
DNE calculations typically discard the top 1 tenth of one percent of faces,
associated with extreme pockets and broken parts of surfaces. DNE
calculations also typically discard the boundary faces from the calculation,
either on the basis of 2 vertices on the boundary, or at least one vertext on
the boundary. concaveCol defaults to gray and therefore is turned off. When
an alternative color is provided, the function will identify the the areas of the
tooth that are concave vs convex.

Details of the other function arguments can be found in the DNE3d() description
and identical terms are organized to function the same way.
}
\examples{
ARC_output <- ARC(Tooth)
ARC3d(ARC_output)
}
