% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{test_functions}
\alias{test_functions}
\alias{Shaffer1}
\alias{Shaffer2}
\alias{Fonseca}
\alias{Kursawe}
\alias{Viennet}
\alias{Binh}
\title{Test functions for optimization}
\usage{
Shaffer1(x)

Shaffer2(x)

Fonseca(x)

Kursawe(x)

Viennet(x)

Binh(x)
}
\arguments{
\item{x, }{numeric value (or vector for multivariable functions)}
}
\description{
This page is a collection of test functions commonly used to test optimization algorithms
}
\examples{

#function should be evaluated in the -A < x < A interval,
#where A is from 10 to 10^5 and \\length(x) = 1
Shaffer1(0)

#function should be evaluated in the -5 < x < 10 interval \\length(x) = 1
Shaffer2(0)

#function should be evaluated in the -20 < x < 20 interval and \\length(x) >= 1
Fonseca(rep(0,10))

#function should be evaluated in the -5 < x < 5 interval and \\length(x) == 3
Kursawe(rep(0,3))

#function should be evaluated in the -3 < x < 3 interval and \\length(x) == 2
Viennet(c(0.5,0.5))

#function should be evaluated in the 0 < x < (5,3) interval and \\length(x) == 2
Binh(c(0,0))
}
\references{
\url{https://en.wikipedia.org/wiki/Test_functions_for_optimization}

\url{http://www.sfu.ca/~ssurjano/optimization.html}
}
