% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliablity_single_item.R
\name{relcorr_single_item}
\alias{relcorr_single_item}
\title{Reliability‑Corrected Single‑Item SEM}
\usage{
relcorr_single_item(
  syntax,
  data,
  choose = NULL,
  scale.corrected = TRUE,
  warn.lav = TRUE
)
}
\arguments{
\item{syntax}{A character string containing lavaan model syntax.  Must at
least include the measurement relations (\code{=~}).}

\item{data}{A \code{data.frame}, \code{tibble} or object coercible to a data frame that
holds the raw observed indicators.}

\item{choose}{\emph{Optional.} Character vector with the names of the latent
variables you wish to replace by single indicators.  Defaults to \strong{all}
first‑order latent variables in \code{syntax}.}

\item{scale.corrected}{Should reliability-corrected items be scale-corrected? If \code{TRUE}
reliability-corrected single items are corrected for differences in factor loadings between
the items. Default is \code{TRUE}.}

\item{warn.lav}{Should warnings from \code{lavaan::cfa} be displayed? If \code{FALSE}, they
are suppressed.}
}
\value{
An object of S3 class \code{modsem_relcorr} (a named list) with elements:
\describe{
  \item{\code{syntax}}{Modified lavaan syntax string.}
  \item{\code{data}}{Data frame with additional composite indicator columns.}
  \item{\code{parTable}}{Parameter table corresponding to `syntax`.}
  \item{\code{reliability}}{Named numeric vector of reliabilities (one per latent
    variable).}
  \item{\code{AVE}}{Named numeric vector with Average Variance Extracted values.}
  \item{\code{lVs}}{Character vector of latent variables that were corrected.}
  \item{\code{single.items}}{Character vector with names for the generated reliability corrected items}
}
}
\description{
Replace (some of) the first‑order latent variables in a lavaan measurement
model by single composite indicators whose error variances are fixed from
Cronbach's \eqn{\alpha}. The function returns a modified lavaan model
syntax together with an augmented data set that contains the newly created
composite variables, so that you can fit the full SEM in a single step.
}
\details{
The resulting object can be fed directly into \code{modsem} or \code{lavaan::sem}
by supplying \code{syntax = $syntax} and \code{data = $data}.
}
\examples{
\dontrun{
tpb_uk <- "
# Outer Model (Based on Hagger et al., 2007)
 ATT =~ att3 + att2 + att1 + att4
 SN =~ sn4 + sn2 + sn3 + sn1
 PBC =~ pbc2 + pbc1 + pbc3 + pbc4
 INT =~ int2 + int1 + int3 + int4
 BEH =~ beh3 + beh2 + beh1 + beh4

# Inner Model (Based on Steinmetz et al., 2011)
 INT ~ ATT + SN + PBC
 BEH ~ INT + PBC
 BEH ~ INT:PBC
"

corrected <- relcorr_single_item(syntax = tpb_uk, data = TPB_UK)
print(corrected)

syntax <- corrected$syntax
data   <- corrected$data

est_dca <- modsem(syntax, data = data, method = "dblcent")
est_lms <- modsem(syntax, data = data, method="lms", nodes=32)
summary(est_lms)
}

}
