% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbsmk.R
\name{bbsmK}
\alias{bbsmK}
\title{Block bootstrapped Mann-Kendall Trend Test}
\usage{
bbsmK(x, ci = 0.95, nsim = 2000, eta = 1, bl.len = NULL)
}
\arguments{
\item{x}{- Time series data vector}

\item{ci}{- Confidence Interval}

\item{nsim}{- Number of simulations}

\item{eta}{- Added to the block length}

\item{bl.len}{- Block length}
}
\value{
Z  - Mann- Kendall Z-statistic

slp  - sen's slope

S  - Mann-Kendall 's'- statistic

Tau  - Mann-Kendall's Tau

lb- Lower bound of confidence interval value

ub- Upper bound of confidence interval value
}
\description{
Block lengths are automatically calculated using the lag of the smallest signigicant auto-correlation coefficient.  And eta value of 1 is used as a default value following the results of Khaliq et al. (2009), 2000 bootstrapped replicates are recommended following the results of Svensson et al. (2005).
}
\details{
Block lengths are automatically selected using the lag of the least significance serial correlation, to which the 'eta'  term is added. A value of eta = 1 is used as the default as per Khaliq et al. (2009).  Alternatively, the user may define the block length.  2000 bootstrap replicates are recommended as per Svensson et al. (2005) and Önöz, B. and Bayazit (2012).
}
\examples{
x<-c(Nile)
bbsmK(x)

}
\references{
Box, G. E. P. and Jenkins, G. M. (1970). Time Series Analysis Forecasting and Control. Holden-Day, San Fransisco, California, 712 pp.

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

Khaliq, M. N., Ouarda, T. B. M. J., Gachon, P., Sushama, L., and St-Hilaire, A. (2009). Identification of hydrological trends in the presence of serial and cross correlations: A review of selected methods and their application to annual flow regimes of Canadian rivers. Journal of Hydrology, 368: 117-130.

Kundzewicz, Z. W. and Robson, A. J. (2000). Detecting Trend and Other Changes in Meteorological Data. World Climate Program ? Data and Monitoring. World Meteorological Organization, Geneva  (WMO/TD-No. 1013).

Kundzewicz, Z. W. and Robson, A. J. (2004). Change detection in hydrological records ? a review of the methodology. Hydrological Sciences Journal, 49(1): 7-19.

Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245?259. <doi:10.1017/CBO9781107415324.004>

Önöz , B. and Bayazit M. (2012). Block bootstrap for Mann-Kendall trend test of serially dependent data. Hydrological Processes, 26: 3552-3560.

Svensson, C., Kundzewicz, Z. W., and Maurer, T. (2005). Trend detection in river flow series: 2. Floods and low-flow index series. Hydrological Sciences Journal, 50(5): 811-823.
}
