% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate.mediation.R
\name{modmed.sens}
\alias{modmed.sens}
\title{Simulation-Based Sensitivity Analysis Table for Causal Moderated Mediation Analysis
modmed.sens' is used to evaluate the sensitivity of the estimated causal effects obtained from \code{modmed} function to potential violations of the ignorability assumptions from the frequentist perspective. It estimates the causal effects after adjusting for an unmeasured pretreatment confounder, U, with a specified degree of confounding. In a randomized experiment, the degree of confounding is evaluated via two sensitivity parameters, the coefficient of U in the mediator model and that in the outcome model, given the specified prior distribution of U. When the treatment is not randomized, an additional sensitivity parameter is introduced -- the coefficient of U in the treatment model. The treatment, mediator, outcome, and unmeasured pretreatment confounder could be either binary or continuous.}
\usage{
modmed.sens(
  object,
  range.b.m = NULL,
  range.b.y = NULL,
  grid.b.m = 20,
  grid.b.y = 20,
  U.scale = "binary",
  p.u = 0.5,
  sigma.u = 1,
  t.rand = TRUE,
  t.model = NULL,
  t.scale = "binary",
  b.t = NULL,
  iter = 10,
  nsim = 5,
  ncore = detectCores()
)
}
\arguments{
\item{object}{Output from the \code{modmed} function.}

\item{range.b.m}{The range of the sensitivity parameter that represents the slope of the unmeasured pretreatment confounder in the standardized mediator model, in which both the independent and dependent variables are standardized. If the dependent variable is binary, its latent index is standardized instead. E.g., it can be specified as c(-2, 2). If NULL, the upper bound of the range is determined by 2 times the maximum magnitude of the standardized conditional effect of the existing pretreatment confounders with the mediator. The lower bound is the negative of the upper bound. The default is NULL.}

\item{range.b.y}{The range of the sensitivity parameter that represents the slope of the unmeasured pretreatment confounder in the standardized outcome model, in which both the independent and dependent variables are standardized. If the dependent variable is binary, its latent index is standardized instead. E.g., it can be specified as c(-2, 2). If NULL, the upper bound of the range is determined by 2 times the maximum magnitude of the standardized conditional effect of the existing pretreatment confounders with the outcome. The lower bound is the negative of the upper bound. The default is NULL.}

\item{grid.b.m}{The horizontal dimension of the grid. The default is 20. Increase the number for more smooth curves.}

\item{grid.b.y}{The vertical dimension of the grid. The default is 20. Increase the number for more smooth curves.}

\item{U.scale}{The scale of the unobserved pretreatment confounder (string). Can be "continuous" or "binary". The default is "binary".}

\item{p.u}{This needs to be specified only if U.scale = "binary". The prior probability of the unobserved pretreatment confounder if it is binary. The default is 0.5.}

\item{sigma.u}{This needs to be specified only if U.scale = "continuous". The standard deviation of the prior distribution of the unobserved pretreatment confounder if it is continuous. The default is 1.}

\item{t.rand}{TRUE if the treatment is randomized, and FALSE if not. The default is TRUE.}

\item{t.model}{A list. The default is NULL. This needs to be specified only if t.rand = FALSE because a treatment model is required for the derivation of the conditional distribution of the unmeasured pretreatment confounder. The names of the list must include intercept and the pretreatment covariates that are predictors but not moderators in the treatment model. The pretreatment covariates should be contained in the union of covariates.disc, and covariates.cont. Each element of the list is a vector of the names of the moderators (string) of the coefficient of the main model predictor as represented by the name of the element. The moderators of the intercept must include all the moderators in the treatment model. If a main model coefficient is not moderated, then the corresponding vector should be specified as NULL. The moderators should be contained in the union of moderators.disc, and moderators.cont.}

\item{t.scale}{The scale of the treatment (string). Can be "continuous" or "binary". The default is "binary".}

\item{b.t}{This needs to be specified only if t.rand = FALSE. The value of the sensitivity parameter that represents the slope of the unmeasured pretreatment confounder in the standardized treatment model, in which both the independent and dependent variables are standardized. If the dependent variable is binary, its latent index is standardized instead. When t.rand = TRUE, b.t is NULL, because when the treatment is randomized, there is no need to specify this sensitivity parameter. Hence, the default of b.t is NULL.}

\item{iter}{The number of iterations in the stochastic EM algorithm for generating the unobserved pretreatment confounder. The default is 10.}

\item{nsim}{The number of random draws of the unobserved pretreatment confounder in each cell. The default is 5. Increase the number for more smooth curves.}

\item{ncore}{The number of cores for parallel computing. The default is the number of CPU cores on the current host.}
}
\value{
A list containing
\item{X.coef.plot}{the sopes of the observed pretreatment confounders in the standardized mediator and outcome models (which are used to calibrate the strength of the sensitivity parameters in the sensitivity plots). }
\item{b.t}{same as specified in the \code{modmed.sens} function if b.t is not NULL.}
\item{range.b.m, range.b.y}{the value range of each sensitivity parameter.}
\item{b.m.all, b.y.all}{all the specific values of the sensitivity parameters for constructing the grids.}
\item{results.new}{tables for the causal effect estimates, standard errors, and p values in all the grids, after the adjustment of the unobserved pretreatment confounder.}
}
\description{
Simulation-Based Sensitivity Analysis Table for Causal Moderated Mediation Analysis
modmed.sens' is used to evaluate the sensitivity of the estimated causal effects obtained from \code{modmed} function to potential violations of the ignorability assumptions from the frequentist perspective. It estimates the causal effects after adjusting for an unmeasured pretreatment confounder, U, with a specified degree of confounding. In a randomized experiment, the degree of confounding is evaluated via two sensitivity parameters, the coefficient of U in the mediator model and that in the outcome model, given the specified prior distribution of U. When the treatment is not randomized, an additional sensitivity parameter is introduced -- the coefficient of U in the treatment model. The treatment, mediator, outcome, and unmeasured pretreatment confounder could be either binary or continuous.
}
\examples{
\donttest{
data(newws)
modmed.results = modmed(data = newws, treatment = "treat", mediator = "emp",
    outcome = "depression", covariates.disc = c("emp_prior", "nevmar",
        "hispanic", "nohsdip"), covariates.cont = c("workpref",
        "attitude", "depress_prior"), moderators.disc = "CHCNT",
    moderators.cont = "ADCPC", m.model = list(intercept = c("ADCPC",
        "CHCNT"), treatment = c("ADCPC", "CHCNT"), emp_prior = NULL,
        nevmar = NULL, hispanic = NULL, nohsdip = NULL, workpref = NULL,
        attitude = NULL, depress_prior = NULL), y.model = list(intercept = c("ADCPC",
        "CHCNT"), treatment = c("ADCPC", "CHCNT"), mediator = c("ADCPC",
        "CHCNT"), tm = c("ADCPC", "CHCNT"), emp_prior = NULL, nevmar = NULL,
        hispanic = NULL, nohsdip = NULL, workpref = NULL, attitude = NULL,
        depress_prior = NULL), comp.mod.disc.values = 3, ref.mod.disc.values = 2,
    comp.mod.cont.values = 5050, ref.mod.cont.values = 5050, m.scale = "binary",
    y.scale = "continuous", seed = 1)
sens.results = modmed.sens(modmed.results, U.scale = "binary",
    grid.b.m = 2, grid.b.y = 2, iter = 2, nsim = 2, ncore = 1)
sens.results = modmed.sens(modmed.results, U.scale = "binary",
    t.model = list(intercept = c("ADCPC", "CHCNT"), emp_prior = "ADCPC",
        nevmar = "CHCNT", hispanic = NULL, nohsdip = NULL, workpref = NULL,
        attitude = NULL, depress_prior = NULL), grid.b.m = 2, grid.b.y = 2,
    iter = 2, nsim = 2, ncore = 1)
}
}
\references{
Qin, X., & Yang, F. (2020). Simulation-Based Sensitivity Analysis for Causal Mediation Studies.
}
\author{
Xu Qin and Fan Yang
}
