% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-adam_params.R
\name{adam_params}
\alias{adam_params}
\alias{use_constant}
\alias{regressors_treatment}
\alias{outliers_treatment}
\alias{probability_model}
\alias{distribution}
\alias{information_criteria}
\alias{select_order}
\title{Tuning Parameters for ADAM Models}
\usage{
use_constant(values = c(FALSE, TRUE))

regressors_treatment(values = c("use", "select", "adapt"))

outliers_treatment(values = c("ignore", "use", "select"))

probability_model(
  values = c("none", "auto", "fixed", "general", "odds-ratio", "inverse-odds-ratio",
    "direct")
)

distribution(
  values = c("default", "dnorm", "dlaplace", "ds", "dgnorm", "dlnorm", "dinvgauss",
    "dgamma")
)

information_criteria(values = c("AICc", "AIC", "BICc", "BIC"))

select_order(values = c(FALSE, TRUE))
}
\arguments{
\item{values}{A character string of possible values.}
}
\value{
A \code{dials} parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter
}
\description{
Tuning Parameters for ADAM Models
}
\details{
The main parameters for ADAM models are:
\itemize{
\item \code{non_seasonal_ar}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{non_seasonal_differences}: The order of integration for non-seasonal differencing.
\item \code{non_seasonal_ma}: The order of the non-seasonal moving average (MA) terms.
\item \code{seasonal_ar}: The order of the seasonal auto-regressive (SAR) terms.
\item \code{seasonal_differences}: The order of integration for seasonal differencing.
\item \code{seasonal_ma}: The order of the seasonal moving average (SMA) terms.
\item \code{use_constant}: Logical, determining, whether the constant is needed in the model or not.
\item \code{regressors_treatment}: The variable defines what to do with the provided explanatory variables.
\item \code{outliers_treatment}: Defines what to do with outliers.
\item \code{probability_model}: The type of model used in probability estimation.
\item \code{distribution}: What density function to assume for the error term.
\item \code{information_criteria}: The information criterion to use in the model selection / combination procedure.
\item \code{select_order}: If TRUE, then the function will select the most appropriate order.
}
}
\examples{
use_constant()

regressors_treatment()

distribution()


}
