% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-accuracy.R
\name{modeltime_accuracy}
\alias{modeltime_accuracy}
\title{Calculate Accuracy Metrics}
\usage{
modeltime_accuracy(
  object,
  new_data = NULL,
  metric_set = default_forecast_accuracy_metric_set(),
  acc_by_id = FALSE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{object}{A Modeltime Table}

\item{new_data}{A \code{tibble} to predict and calculate residuals on.
If provided, overrides any calibration data.}

\item{metric_set}{A \code{yardstick::metric_set()} that is used to summarize one or more
forecast accuracy (regression) metrics.}

\item{acc_by_id}{Should a global or local model accuracy be produced? (Default: FALSE)
\itemize{
\item When \code{FALSE}, a global model accuracy is provided.
\item If \code{TRUE}, a local accuracy is provided group-wise for each time series ID.
To enable local accuracy, an \code{id} must be provided during \code{modeltime_calibrate()}.
}}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them as they occur?}

\item{...}{If \code{new_data} is provided, these parameters are passed to \code{modeltime_calibrate()}}
}
\value{
A tibble with accuracy estimates.
}
\description{
This is a wrapper for \code{yardstick} that simplifies time series regression accuracy metric
calculations from a fitted \code{workflow} (trained workflow) or \code{model_fit} (trained parsnip model).
}
\details{
The following accuracy metrics are included by default via \code{\link[=default_forecast_accuracy_metric_set]{default_forecast_accuracy_metric_set()}}:
\itemize{
\item MAE - Mean absolute error, \code{\link[=mae]{mae()}}
\item MAPE - Mean absolute percentage error, \code{\link[=mape]{mape()}}
\item MASE  - Mean absolute scaled error, \code{\link[=mase]{mase()}}
\item SMAPE - Symmetric mean absolute percentage error, \code{\link[=smape]{smape()}}
\item RMSE  - Root mean squared error, \code{\link[=rmse]{rmse()}}
\item RSQ   - R-squared, \code{\link[=rsq]{rsq()}}
}
}
\examples{
library(tidymodels)
library(tidyverse)
library(lubridate)
library(timetk)
library(modeltime)


# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

# --- MODELS ---

# Model 1: prophet ----
model_fit_prophet <- prophet_reg() \%>\%
    set_engine(engine = "prophet") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_prophet
)

# ---- ACCURACY ----

models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits)) \%>\%
    modeltime_accuracy(
        metric_set = metric_set(mae, rmse, rsq)
    )


}
