% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-arima_reg.R
\name{Arima_fit_impl}
\alias{Arima_fit_impl}
\title{Low-Level ARIMA function for translating modeltime to forecast}
\usage{
Arima_fit_impl(
  x,
  y,
  period = "auto",
  p = 0,
  d = 0,
  q = 0,
  P = 0,
  D = 0,
  Q = 0,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{period}{A seasonal frequency. Uses "auto" by default. A character phrase
of "auto" or time-based phrase of "2 weeks" can be used if a date or date-time variable is provided.}

\item{p}{The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.}

\item{d}{The order of integration for non-seasonal differencing. Often denoted "d" in pdq-notation.}

\item{q}{The order of the non-seasonal moving average (MA) terms. Often denoted "q" in pdq-notation.}

\item{P}{The order of the seasonal auto-regressive (SAR) terms. Often denoted "P" in PDQ-notation.}

\item{D}{The order of integration for seasonal differencing. Often denoted "D" in PDQ-notation.}

\item{Q}{The order of the seasonal moving average (SMA) terms. Often denoted "Q" in PDQ-notation.}

\item{...}{Additional arguments passed to \code{forecast::Arima}}
}
\description{
Low-Level ARIMA function for translating modeltime to forecast
}
