% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dependency.R
\name{set_dependency}
\alias{set_dependency}
\alias{get_dependency}
\title{Register Dependency for Model}
\usage{
set_dependency(model, mode, eng, pkg)

get_dependency(model)
}
\arguments{
\item{model}{A single character string for the model type (e.g.
\code{"k_means"}, etc).}

\item{mode}{A single character string for the model mode (e.g. "partition").}

\item{eng}{A single character string for the model engine.}

\item{pkg}{An options character string for a package name.}
}
\value{
A tibble
}
\description{
This function is used to register a mode for a model, engine, and mode
combination.
}
\details{
This function should for each package that needs to be added as a dependency.
The \code{mode} needs to be set explicitly, and dependencies needs to be specified
for each \code{model}, \code{mode} and \code{eng} combination.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_new_model("shallow_learning_model")
set_model_mode("shallow_learning_model", "partition")
set_model_engine("shallow_learning_model", "partition", "stats")

set_dependency("shallow_learning_model", "partition", "stats", "base")
get_dependency("shallow_learning_model")
get_dependency("shallow_learning_model")$pkg

set_dependency("shallow_learning_model", "partition", "stats", "stats")
get_dependency("shallow_learning_model")
get_dependency("shallow_learning_model")$pkg

# Only unique packages are kept
set_dependency("shallow_learning_model", "partition", "stats", "stats")
get_dependency("shallow_learning_model")
get_dependency("shallow_learning_model")$pkg
\dontshow{\}) # examplesIf}
}
