% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_graph.R
\name{plot.model_graph}
\alias{plot.model_graph}
\title{Plot a Network of Models}
\usage{
\method{plot}{model_graph}(x, ...)
}
\arguments{
\item{x}{The output of
\code{\link[=model_graph]{model_graph()}}. (Named \code{x}
because it is required in the naming
of arguments of the \code{plot} generic
function.)}

\item{...}{Additional arguments,
passed to \code{\link[=plot.igraph]{plot.igraph()}}.}
}
\value{
\code{NULL}. Called for its
side effect.
}
\description{
Plot a network of models
generated by \code{model_graph()}.
}
\details{
This function is the plot
method of \code{model_graph} objects,
the output of
\code{\link[=model_graph]{model_graph()}}.

For now, it simply passes the object
to \code{\link[=plot.igraph]{plot.igraph()}}. This function
is created for possible customization
of the plot in the future.
}
\examples{

library(lavaan)

dat <- dat_path_model

mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"

fit <- sem(mod, dat_path_model, fixed.x = TRUE)

out <- model_set(fit)
out

g <- model_graph(out)
plot(g)

}
\seealso{
\code{\link[=model_graph]{model_graph()}}
}
