% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation_matrix.R
\name{visualisation_matrix}
\alias{visualisation_matrix}
\alias{visualisation_matrix.data.frame}
\alias{visualisation_matrix.numeric}
\alias{visualisation_matrix.factor}
\title{Create a reference grid}
\usage{
visualisation_matrix(x, ...)

\method{visualisation_matrix}{data.frame}(
  x,
  at = "all",
  target = NULL,
  factors = "reference",
  numerics = "mean",
  preserve_range = FALSE,
  reference = x,
  ...
)

\method{visualisation_matrix}{numeric}(x, ...)

\method{visualisation_matrix}{factor}(x, ...)
}
\arguments{
\item{x}{An object from which to construct the reference grid.}

\item{...}{Arguments passed to or from other methods (for instance, \code{length}
or \code{range} to control the spread of numeric variables.).}

\item{at}{Can be \code{"all"}, a character vector or list of named elements, indicating
the predictors of interest (focal predictors). Can also contain assignments
(as named list, e.g. \code{at = list(c(Sepal.Length = c(2, 4), Species = "setosa"))},
or as string, e.g. \code{at = "Sepal.Length = 2"} or
\code{at = c("Sepal.Length = 2", "Species = 'setosa'")} - note the usage of single
and double quotes to assign strings within strings). The remaining variables
will be fixed.}

\item{target}{Deprecated name. Please use \code{at} instead.}

\item{factors}{Type of summary for factors. Can be \code{"reference"} (set at the
reference level), \code{"mode"} (set at the most common level) or \code{"all"} to
keep all levels.}

\item{numerics}{Type of summary for numeric values. Can be \code{"all"} (will
duplicate the grid for all unique values), any function (\code{"mean"},
\code{"median"}, ...) or a value (e.g., \code{numerics = 0}).}

\item{preserve_range}{In the case of combinations between numeric variables
and factors, setting \code{preserve_range = TRUE} will drop the observations
where the value of the numeric variable is originally not present in the
range of its factor level. This leads to an unbalanced grid. Also, if you
want the minimum and the maximum to closely match the actual ranges, you
should increase the \code{length} argument.}

\item{reference}{The reference vector from which to compute the mean and SD.
Used when standardizing or unstandardizing the grid using \code{effectsize::standardize}.}
}
\value{
Reference grid data frame.
}
\description{
This function is an alias (another name) for the \code{\link[insight:get_datagrid]{insight::get_datagrid()}}
function. Same arguments apply.
}
\examples{
library(modelbased)

# Add one row to change the "mode" of Species
data <- rbind(iris, iris[149, ], make.row.names = FALSE)

# Single variable is of interest; all others are "fixed"
visualisation_matrix(data, at = "Sepal.Length")
visualisation_matrix(data, at = "Sepal.Length", length = 3)
visualisation_matrix(data, at = "Sepal.Length", range = "ci", ci = 0.90)
visualisation_matrix(data, at = "Sepal.Length", factors = "mode")

# Multiple variables are of interest, creating a combination
visualisation_matrix(data, at = c("Sepal.Length", "Species"), length = 3)
visualisation_matrix(data, at = c(1, 3), length = 3)
visualisation_matrix(data, at = c("Sepal.Length", "Species"), preserve_range = TRUE)
visualisation_matrix(data, at = c("Sepal.Length", "Species"), numerics = 0)
visualisation_matrix(data, at = c("Sepal.Length = 3", "Species"))
visualisation_matrix(data, at = c("Sepal.Length = c(3, 1)", "Species = 'setosa'"))

# with list-style at-argument
visualisation_matrix(data, at = list(Sepal.Length = c(1, 3), Species = "setosa"))

# Standardize
vizdata <- visualisation_matrix(data, at = "Sepal.Length")
standardize(vizdata)
}
