% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pmtree.R
\name{survreg_plot}
\alias{survreg_plot}
\title{Survival plot for a given survreg model
with one binary covariate.}
\usage{
survreg_plot(mod, data = NULL, theme = theme_classic(), yrange = NULL)
}
\arguments{
\item{mod}{A model of class survreg.}

\item{data}{optional data frame. If NULL the data stored in mod is used.}

\item{theme}{A ggplot2 theme.}

\item{yrange}{Range of the y variable to be used for plotting. 
If NULL it will be 0 to max(y).}
}
\description{
Can be used on its own but is also useable as plotfun in 
\code{\link{node_pmterminal}}.
}
\examples{
if(require("survival")) {
  survreg_plot(survreg(Surv(futime, fustat) ~ factor(rx), ovarian))
}

}
