% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modcmfitrFunctions.R
\name{fitMultiplemCM}
\alias{fitMultiplemCM}
\title{Fit modified Connor-Mosimann distributions to multiple experts' opinions}
\usage{
fitMultiplemCM(Quantiles, SearchParams, RawData)
}
\arguments{
\item{Quantiles}{Sets the quantiles to be fit.  If median and 95\% Credibility Intervals, then set to c(0.025,0.5,0.975).  If median and tertiles then c(0.33,0.5,0.66).  If median and quartiles then c(0.25,0.5,0.75) and so on.}

\item{SearchParams}{A vector of number of iterations and max number of searches.
Number of iterations is the number of draws from the mCM distribution used to estimate the quantiles.  10,000 is a good number to try first.
Max number of searches is the maximum number of searches the search algorithm conducts.  The higher the better the fit, but also the longer it takes to find it.}

\item{RawData}{Data frame of data elicited from experts.  Must have five columns: expert, outcome, lower quantile, median, upper quantile.}
}
\value{
Returns a matrix, each row representing one of the Outcomes for each expert.  Columns a, b, LL and UL are the parameters of the mCM distribution.  
Note that the final row will always be zeroes as the number of rows of the mCM distribution is k-1 where k is the number of outcomes.
The next three columns (Tgt_LL, Tgt_MED, Tgt_UL) are the target quantiles input to the function as 'RawData' in the example above.
The final three (Mdl_LL, Mdl_MED, Mdl_UL) are the quantiles resulting from the model fitting.  If the mCM is a good fit, the Mdl columns will be 
identical to the Tgt columns.
}
\description{
This function fits a modified CM distribution to an elicited set of quantiles from multiple experts.
It saves time by calculating the results for several experts at once, rather than having to call fitModCM() for each expert.
It takes a raw datafile with the elicited quantiles from each expert, divides it up expert by expert, and calls
fitModCM() once for each expert, returning a data frame with Zed parameters of the modCM distribution for each, along with the target and modelled quantiles.
}
\examples{
Quantiles <- c(0.025,0.5,0.975) # to fit median and 95\% Credibility Intervals
SearchParams <- c(10000,100) # number of iterations, max number of searches
RawData <- data.frame(expert = as.character(c(1,1,1,2,2,2)),
                      Outcome = as.factor(c("Remission","Progression","Dead",
                                           "Remission","Progression","Dead")),
                      LL = as.numeric(c(0.43, 0.16, 0.03, 0.35, 0.15, 0.00)),
                     MED = as.numeric(c(0.55, 0.27, 0.18, 0.60, 0.30, 0.10)),
                      UL = as.numeric(c(0.65, 0.46, 0.23, 0.70, 0.45, 0.20)))

fitMultiplemCM(Quantiles, SearchParams, RawData)
}
\keyword{Connor-Mosimann}
\keyword{modified}
