% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_param.R
\name{curveParam_RT}
\alias{curveParam_RT}
\title{Standard estimation of Maximum Reading Speed (MRS) and Critical Print Size (CPS) 
using individual data of reading time and number of errors.}
\usage{
curveParam_RT(data, print_size, viewing_distance, reading_time, errors,
  ... = NULL)
}
\arguments{
\item{data}{The name of your dataframe}

\item{print_size}{The variable that contains print size values for each sentence (print size uncorrected for viewing distance)}

\item{viewing_distance}{The variable that contains the viewing distance value used for testing}

\item{reading_time}{The variable that contains the reading time for each sentence}

\item{errors}{The variable that contains the number of errors for each sentence}

\item{...}{Optional grouping arguments}
}
\value{
The function returns a new dataframe with two variables:
 \itemize{
  \item "CPS" -> contains the Critical Print Size estimate (in logMAR)
  \item "MRS" -> contains the Maximum Reading Speed estimate (in words/min)
  }
}
\description{
This function estimates simultaneously:
 \itemize{
  \item Maximum Reading Speed (MRS)
  \item Critical Print Size (CPS)
  }
while performing print size correction for non-standard testing viewing distance.
}
\section{Notes}{

This function uses the original algorithm described in Legge (2007) to estimate Maximum Reading Speed (MRS) and Critical Print Size (CPS).
This algorithm searches for a reading speed plateau in the data. A plateau is defined as a range of print sizes
that supports reading speed at a significantly faster rate than the print sizes smaller or larger than the plateau range.
Concretely, the plateau is determined as print sizes which reading speed is at least 1.96 SD faster than the other print sizes.
The Maximum Reading Speed is estimated as the mean reading speed for print sizes included in the plateau.
The Critical Print Size is defined as the smallest print size on the plateau.

For more details on the original algorithm, see Chapter 5 of this book:\\
Legge, G.E. (2007). Psychophysics of Reading in Normal and Low Vision. Mahwah, NJ & London: Lawrence Erlbaum Associates. ISBN 0-8058-4328-0
\url{https://books.google.fr/books/about/Psychophysics_of_Reading_in_Normal_and_L.html?id=BGTHS8zANiUC&redir_esc=y}

To ensure proper estimation of the MRS and CPS, individual MNREAD curves should be plotted using \code{\link{mnreadCurve}} and inspected visually.
}

\section{Warning}{

For the function to run properly, one needs to make sure that the variables are of the class:
 \itemize{
  \item \strong{print_size} -> numeric
  \item \strong{viewing_distance} -> integer
  \item \strong{reading_time} -> numeric
  \item \strong{errors} -> integer
  }

In cases where only 3 or less sentences were read during a test,
the function won't be able to estimate the MRS and CPS
and will return NA values instead.
The ACC should be used to estimate the MNREAD score in such cases
where there are not enough data points to fit the MNREAD curve.

To ensure proper parameters estimation, the data should be entered along certain rules:
 \itemize{
  \item For the smallest print size that is presented but not read, right before the test is stopped: \strong{reading_time = NA, errors = 10}
  \item For all the small sentences that are not presented because the test was stopped before them: \strong{reading_time = NA, errors = NA}
  \item If a sentence is presented, and read, but the time was not recorded by the experimenter: \strong{reading_time = NA, errors = actual number of errors} (cf. s5-regular in low vision data sample)
  \item If a large sentence was skipped to save time but would have been read well: \strong{reading_time = NA, errors = NA} (cf. s1-regular in normal vision data sample)
  \item If a large sentence was skipped to save time because the subject cannot read large print: \strong{reading_time = NA, errors = 10} (cf. s7 in low vision data sample)
  }
}

\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test only (subject s1, regular polarity)
data_s1 <- data_low_vision \%>\%
   filter (subject == "s1", polarity == "regular")

# run the parameters estimation
data_low_vision_MRS_CPS <- curveParam_RT(data_s1, ps, vd, rt, err)

# inspect the newly created dataframe
data_low_vision_MRS_CPS

#------

# run the parameters estimation on the whole dataset grouped by subject and polarity
data_low_vision_MRS_CPS <- curveParam_RT(data_low_vision, ps, vd, rt, err,
                                           subject, polarity)

# inspect the structure of the newly created dataframe
head(data_low_vision_MRS_CPS, 10)

}
\seealso{
\code{\link{curveParam_RS}} for standard MRS and CPS estimation using values of reading speed (instead of reading time)

 \code{\link{nlmeParam}} for MRS and CPS estimation using nonlinear mixed-effect (NLME) modeling

 \code{\link{mnreadParam}} for all MNREAD parameters estimation (using standard calculation)

 \code{\link{readingAcuity}} for Reading Acuity calculation

 \code{\link{accIndex}} for Reading Accessibility Index calculation
}
