set.seed(0)
n <- 200

pdf("resprop.pdf", width=10, height=6)
par(mfcol=c(2,2))
x <- runif(n)
u <- rnorm(n)
plot(x, u, ylim=c(-7,7), main="Appropriate model", axes=F, ylab="residuals", xlab="", pch=19)
box()
axis(2, at=0)
abline(h=0)

u <- (3*x+0.5)*rnorm(n)
plot(x, u, ylim=c(-8,8), main="Nonconstancy of error", axes=F, ylab="residuals", xlab="", pch=19)
box()
axis(2, at=0)
abline(h=0)

u <- rnorm(n)-25*(x-0.25)*(x-0.75)
plot(x, u, ylim=c(-8,8), main="Nonlinearity of regression function", axes=F, ylab="residuals", xlab="", pch=19)
box()
axis(2, at=0)
abline(h=0)

u <- rnorm(n)+10*(x-0.5)
plot(x, u, ylim=c(-8,8), main="Nonindependence of error term", axes=F, ylab="residuals", xlab="", pch=19)
box()
axis(2, at=0)
abline(h=0)
dev.off()
if (interactive()) browseURL(paste0(getwd(),"/resprop.pdf"))
