% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{emmeans_support}
\alias{emmeans_support}
\title{Support for \code{emmeans}}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This package includes methods that allow \code{mmrm} objects to be used
with the \code{emmeans} package. \code{emmeans} computes estimated marginal means
(also called least-square means) for the coefficients of the MMRM.
}
\examples{
fit <- mmrm(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data
)
if (require(emmeans)) {
  emmeans(fit, ~ ARMCD | AVISIT)
}
}
