% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{skeletonise}
\alias{skeletonise}
\alias{skeletonize}
\title{Skeletonise a numeric array}
\usage{
skeletonise(x, kernel = NULL, method = c("lantuejoul", "beucher", "hitormiss"))
}
\arguments{
\item{x}{An object that can be coerced to an array, or for which a
\code{\link{morph}} method exists.}

\item{kernel}{An array representing the kernel to be used for the underlying
morphology operations. The kernel is fixed for the \code{"hitormiss"}
method, so this argument will be ignored.}

\item{method}{A string giving the method to use. See Details.}
}
\value{
A skeletonised array with the same dimensions as the original array.
}
\description{
Skeletonisation is the process of thinning a shape to a medial line or
surface, and can be achieved using elementary mathematical morphology
operations in a number of ways. Three methods are available through this
function. They are all iterative and therefore relatively time-consuming.
}
\details{
The default method is Lantuéjoul's formula, a union across repeated
erosions, which works in any number of dimensions and may produce
reasonable results on greyscale images, but does not in general produce a
connected skeleton. Beucher introduced an alternative which may produce a
better result (although again the skeleton may not be connected), but this
implementation of the latter algorithm only applies to binary arrays. The
final method uses the so-called hit-or-miss transform, which searches for
exact patterns in the source array. This is guaranteed to produce a
connected skeleton, which is often desirable, but uses fixed kernels (so the
\code{kernel} argument is ignored) and is currently only implemented for 2D
binary arrays.
}
\examples{
x <- c(0,0,1,0,0,0,1,1,1,0,0)
k <- c(1,1,1)
skeletonise(x,k)
}
\references{
C. Lantuéjoul (1977). Sur le modèle de Johnson-Mehl généralisé. Technical
report, Centre de Morphologie Mathématique, Fontainebleau, France.

S. Beucher (1994). Digital skeletons in Euclidean and geodesic spaces.
Signal Processing 38(1):127-141.
\url{https://doi.org/10.1016/0165-1684(94)90061-2}.
}
\seealso{
\code{\link{morphology}}
}
\author{
Jon Clayden <code@clayden.org>
}
