% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-opal_functions.R
\name{data_dict_opalr_fix}
\alias{data_dict_opalr_fix}
\title{Transform a data dictionary object from 'opalr' format to Opal format}
\usage{
data_dict_opalr_fix(data_dict)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be
transformed. Automatically generated if not provided.}
}
\value{
A list of tibble(s) identifying a data dictionary.
}
\description{
Transforms a data dictionary from 'opalr' format to Opal format.
A data dictionary imported using the 'opalr' package has a different
structure and will be transformed to the structure used in Maelstrom
packages.
}
\details{
Opal is the OBiBa application for data management, and Opal environments can
be integrated with RStudio environments using the package \code{opalr}.
The user must have adequate credentials to interact with a specific Opal
environment. Some function errors produced may be associated with the
handler or Opal read/write permissions.
}
\examples{
\donttest{

library(opalr)
opal <- 
 opal.login('administrator','password',
   url ='https://opal-demo.obiba.org/')
   
# use DEMO_files provided by the package
library(madshapR)
library(stringr)

dossier <-
  DEMO_files[str_detect(names(DEMO_files),"dataset_MELBOURNE")]

tempdir <- basename(tempdir())
try(opal_project_create(opal, tempdir))

try(
  opal_tables_push(
  opal, dossier,project_name = tempdir, .force = TRUE, .overwrite = TRUE))

# get the data dictionary and reshape it.
 data_dict <-
   try(
   opal.table_dictionary_get(
   opal,project = tempdir,table = "dataset_MELBOURNE_1"))

 data_dict <- try(data_dict_opalr_fix(data_dict))
  
}

}
\seealso{
Please see \href{https://opaldoc.obiba.org/en/dev/}{Opal documentation} for
complete documentation.
\code{\link[madshapR:as_data_dict_mlstr]{madshapR::as_data_dict_mlstr()}}
}
