% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_statistics.R
\name{lrv_measure}
\alias{lrv_measure}
\title{Comparing bias or mse of lrv estimators based on numerical methods}
\usage{
lrv_measure(
  data,
  param,
  lrvmethod,
  mvselect = -1,
  tau = 0,
  verbose_dist = FALSE,
  mode = "mse"
)
}
\arguments{
\item{data}{a list of data}

\item{param}{a list of parameters}

\item{lrvmethod}{int, method of long-run variance estimation}

\item{mvselect}{int, method of MV selection}

\item{tau}{double, value of tau. If tau is 0, a rule-of-thunk value will be applied}

\item{verbose_dist}{bool, whether to output distributional information}

\item{mode}{default "mse", It can be set as "bias".}
}
\value{
empirical MSE of the estimator.
}
\description{
Comparing bias or mse of lrv estimators based on numerical methods
}
\examples{
n = 300
param = list(gcv = 1, neighbour = 1,lb = 6, ub = 13, ind = 2)    # covariates heterskadecity
data = bregress2(n, 2, 1) # with 2 change pointa
lrv_measure(data, param, lrvmethod = -1, mvselect = -2) #ols plug-in
#debiased difference-based
lrv_measure(data, param, lrvmethod = 1, mvselect = -2)
}
