% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMBO.R
\name{initSMBO}
\alias{initSMBO}
\title{Initialize a manual sequential MBO run.}
\usage{
initSMBO(
  par.set,
  design,
  learner = NULL,
  control,
  minimize = rep(TRUE, control$n.objectives),
  noisy = FALSE,
  show.info = getOption("mlrMBO.show.info", TRUE)
)
}
\arguments{
\item{par.set}{[\code{\link[ParamHelpers]{ParamSet}}]\cr
See \code{\link{mbo}}.}

\item{design}{[\code{data.frame}]\cr
Initial design as data frame.
If the y-values are not already present in design, mbo will evaluate the points.
If the parameters have corresponding trafo functions, the design must not be transformed before it is passed!
Functions to generate designs are available in \code{ParamHelpers}: \code{\link[ParamHelpers]{generateDesign}}, \code{\link[ParamHelpers]{generateGridDesign}}, \code{\link[ParamHelpers]{generateRandomDesign}}.
Default is \code{NULL}, which means \code{\link[ParamHelpers]{generateDesign}} is called and a design of size 4 times number of all parameters is created
The points are drawn via \code{\link[lhs]{maximinLHS}} to maximize the minimal distance between design points.}

\item{learner}{[\code{\link[mlr]{Learner}}]\cr
Regression learner from mlr, which is used as a surrogate to model our fitness function.
If \code{NULL} (default), the default learner is determined as described here: \link{mbo_default_learner}.}

\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{minimize}{[\code{logical}]\cr
Should objective values of the target functions be minimized? One value par objective.
Default is \code{TRUE} for every objective.}

\item{noisy}{[\code{logical(1)}]\cr
Is the target function noisy?
Default is \code{FALSE}.}

\item{show.info}{[\code{logical(1)}]\cr
Verbose output on console?
Default is \code{TRUE}.}
}
\value{
[\code{\link{OptState}}]
}
\description{
When you want to run a human-in-the-loop MBO run you need to initialize it first.
}
