% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionSurv.R
\name{autoplot.PredictionSurv}
\alias{autoplot.PredictionSurv}
\title{Plot for PredictionSurv}
\usage{
\method{autoplot}{PredictionSurv}(
  object,
  type = c("calib", "dcalib"),
  task = NULL,
  row_ids = NULL,
  times = NULL,
  xyline = TRUE,
  cuts = 11L,
  ...
)
}
\arguments{
\item{object}{(\link[mlr3proba:PredictionSurv]{mlr3proba::PredictionSurv}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{task}{(\link[mlr3proba:TaskSurv]{mlr3proba::TaskSurv}) \cr
If \code{type = "calib"} then \code{task} is passed to \verb{$predict} in the Kaplan-Meier learner.}

\item{row_ids}{(\code{integer()}) \cr
If \code{type = "calib"} then \code{row_ids} is passed to \verb{$predict} in the Kaplan-Meier learner.}

\item{times}{(\code{numeric()}) \cr
If \code{type = "calib"} then \code{times} is the values on the x-axis to plot over,
if \code{NULL} uses all times from \code{task}.}

\item{xyline}{(\code{logical(1)}) \cr
If \code{TRUE} (default) plots the x-y line for \code{type = "dcalib"}.}

\item{cuts}{(\code{integer(1)}) \cr
Number of cuts in (0,1) to plot \code{dcalib} over, default is \code{11}.}

\item{...}{(\code{any}):
Additional arguments, currently unused.}
}
\description{
Generates plots for \link[mlr3proba:PredictionSurv]{mlr3proba::PredictionSurv}, depending on argument \code{type}:
\itemize{
\item \code{"calib"} (default): Calibration plot comparing the average predicted survival distribution
to a Kaplan-Meier prediction, this is \emph{not} a comparison of a stratified \code{crank} or \code{lp}
prediction. \code{object} must have \code{distr} prediction. \code{geom_line()} is used for comparison split
between the prediction (\code{Pred}) and Kaplan-Meier estimate (\code{KM}). In addition labels are added
for the x (\code{T}) and y (\code{S(T)}) axes.
\item \code{"dcalib"}: Distribution calibration plot. A model is D-calibrated if X\% of deaths occur before
the X/100 quantile of the predicted distribution, e.g. if 50\% of observations die before their
predicted median survival time. A model is D-calibrated if the resulting plot lies on x = y.
}
}
\examples{
library(mlr3)
library(mlr3proba)
library(mlr3viz)

learn = lrn("surv.coxph")
task = tsk("unemployment")
p = learn$train(task, row_ids = 1:300)$predict(task, row_ids = 301:400)

# calibration by comparison of average prediction to Kaplan-Meier
autoplot(p, type = "calib", task = task, row_ids = 301:400)

# Distribution-calibration (D-Calibration)
autoplot(p, type = "dcalib")
}
\references{
Haider H, Hoehn B, Davis S, Greiner R (2020).
\dQuote{Effective Ways to Build and Evaluate Individual Survival Distributions.}
\emph{Journal of Machine Learning Research}, \bold{21}(85), 1-63.
\url{https://jmlr.org/papers/v21/18-772.html}.
}
