% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvPenalized.R
\name{LearnerSurvPenalized}
\alias{LearnerSurvPenalized}
\alias{mlr_learners_surv.penalized}
\title{L1 and L2 Penalized Estimation in GLMs Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[penalized:penalized]{penalized::penalized()}}.
\itemize{
\item distr is predicted using \code{\link[penalized:predict]{penalized::predict()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}

The \code{penalized} and \code{unpenalized} arguments in the learner are implemented slightly
differently than in \code{\link[penalized:penalized]{penalized::penalized()}}. Here, there is no parameter for \code{penalized} but
instead it is assumed that every variable is penalized unless stated in the \code{unpenalized} parameter,
see examples.
}
\section{Construction}{
\preformatted{LearnerSurvPenalized$new()
mlr_learners$get("surv.penalized")
lrn("surv.penalized")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank}
\item Feature Types: \verb{integer, numeric, factor, ordered}
\item Packages: \CRANpkg{penalized} \CRANpkg{distr6}
}
}

\examples{
library(mlr3)
task = tgen("simsurv")$generate(20)
learner = lrn("surv.penalized")
resampling = rsmp("cv", folds = 2)
resample(task, learner, resampling)

# specifying penalized and unpenalized variables
task = tgen("simsurv")$generate(20)
learner = lrn("surv.penalized", unpenalized = c("height"))
learner$train(task)
learner$model@penalized
learner$model@unpenalized
}
\references{
\cite{mlr3proba}{goeman_2009}
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}: \link[mlr3:mlr_learners]{mlr3::mlr_learners}

Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
