% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpImputeOOR.R
\name{mlr_pipeops_imputeoor}
\alias{mlr_pipeops_imputeoor}
\alias{PipeOpImputeOOR}
\title{Out of Range Imputation}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOpImpute}}/\code{\link{PipeOp}}.
}
\description{
Impute factorial features by adding a new level \code{".MISSING"}.

Impute numerical features by constant values shifted below the minimum or above the maximum by
using \eqn{min(x) - offset - multiplier * diff(range(x))} or
\eqn{max(x) + offset + multiplier * diff(range(x))}.

This type of imputation is especially sensible in the context of tree-based methods, see also
Ding & Simonoff (2010).

\code{\link[mlr3:Learner]{Learner}}s expect input \code{\link[mlr3:Task]{Task}}s to have the same \code{factor} (or \code{ordered}) levels during
training as well as prediction. This \code{PipeOp} modifies the levels of \code{factor} and \code{ordered} features,
and since it may occur that a \code{factor} or \code{ordered} feature contains missing values only during prediction, but not
during training, the output \code{Task} could also have different levels during the two stages.

To avoid problems with the \code{Learner}s' expectation, controlling the \code{PipeOp}s' handling of this edge-case is necessary.
For this, use the \code{create_empty_level} hyperparameter inherited from \code{\link{PipeOpImpute}}.\cr
If \code{create_empty_level} is set to \code{TRUE}, then an unseen level \code{".MISSING"} is added to the feature during
training and missing values are imputed as \code{".MISSING"} during prediction.
However, empty factor levels during training can be a problem for many \code{\link[mlr3:Learner]{Learners}}.\cr
If \code{create_empty_level} is set to \code{FALSE}, then no empty level is introduced during training, but columns that
have missing values only during prediction will \emph{not} be imputed. This is why it may still be necessary to use
\code{\link[=mlr_pipeops_imputesample]{po("imputesample", affect_columns = selector_type(types = c("factor", "ordered")))}}
(or another imputation method) after this imputation method.
Note that setting \code{create_empty_level} to \code{FALSE} is the same as setting it to \code{TRUE} and using \code{\link{PipeOpFixFactors}}
after this \code{PipeOp}.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpImputeOOR$new(id = "imputeoor", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"imputeoor"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpImpute}}.

The output is the input \code{\link[mlr3:Task]{Task}} with all affected features having missing values imputed as described above.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpImpute}}.

The \verb{$state$model} contains either \code{".MISSING"} used for \code{character} and \code{factor} (also
\code{ordered}) features or \code{numeric(1)} indicating the constant value used for imputation of
\code{integer} and \code{numeric} features.
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpImpute}}, as well as:
\itemize{
\item \code{min} :: \code{logical(1)} \cr
Should \code{integer} and \code{numeric} features be shifted below the minimum? Initialized to \code{TRUE}. If \code{FALSE}
they are shifted above the maximum. See also the description above.
\item \code{offset} :: \code{numeric(1)} \cr
Numerical non-negative offset as used in the description above for \code{integer} and \code{numeric}
features. Initialized to \code{1}.
\item \code{multiplier} :: \code{numeric(1)} \cr
Numerical non-negative multiplier as used in the description above for \code{integer} and \code{numeric}
features. Initialized to \code{1}.
}
}

\section{Internals}{

Adds an explicit new \code{level()} to \code{factor} and \code{ordered} features, but not to \code{character} features.
For \code{integer} and \code{numeric} features uses the \code{min}, \code{max}, \code{diff} and \code{range} functions.
\code{integer} and \code{numeric} features that are entirely \code{NA} are imputed as \code{0}. \code{factor} and \code{ordered} features that are
entirely \code{NA} are imputed as \code{".MISSING"}.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpImpute}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")
set.seed(2409)
data = tsk("pima")$data()
data$y = factor(c(NA, sample(letters, size = 766, replace = TRUE), NA))
data$z = ordered(c(NA, sample(1:10, size = 767, replace = TRUE)))
task = TaskClassif$new("task", backend = data, target = "diabetes")
task$missings()
po = po("imputeoor")
new_task = po$train(list(task = task))[[1]]
new_task$missings()
new_task$data()

# recommended use when missing values are expected during prediction on
# factor columns that had no missing values during training
gr = po("imputeoor", create_empty_level = FALSE) \%>>\%
  po("imputesample", affect_columns = selector_type(types = c("factor", "ordered")))
t1 = as_task_classif(data.frame(l = as.ordered(letters[1:3]), t = letters[1:3]), target = "t")
t2 = as_task_classif(data.frame(l = as.ordered(c("a", NA, NA)), t = letters[1:3]), target = "t")
gr$train(t1)[[1]]$data()

# missing values during prediction are sampled randomly
gr$predict(t2)[[1]]$data()
}
\references{
Ding Y, Simonoff JS (2010).
\dQuote{An Investigation of Missing Data Methods for Classification Trees Applied to Binary Response Data.}
\emph{Journal of Machine Learning Research}, \bold{11}(6), 131-170.
\url{https://jmlr.org/papers/v11/ding10a.html}.
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEncodePL}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_decode}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encodeplquantiles}},
\code{\link{mlr_pipeops_encodepltree}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_pi_cvplus}},
\code{\link{mlr_pipeops_learner_quantiles}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nearmiss}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tomek}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Imputation PipeOps: 
\code{\link{PipeOpImpute}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputesample}}
}
\concept{Imputation PipeOps}
\concept{PipeOps}
