% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dictionary.R
\docType{data}
\name{Dictionary}
\alias{Dictionary}
\title{Key-Value Storage}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
A simple key-value store for \link[R6:R6]{R6::R6} generator objects.
On retrieval of an object, the following applies:
\itemize{
\item If the object is a \code{R6ClassGenerator}), it is initialized with \code{new()}.
\item If the object is a function, it is called and must return an instance of a \link[R6:R6]{R6::R6} object.
\item All other objects are returned as-is.
}
}
\section{Construction}{
\preformatted{d = Dictionary$new()
}
}

\section{Methods}{

\itemize{
\item \code{get(key, ...)}\cr
(\code{character(1)}, ...) -> \code{any}\cr
Retrieves object with key \code{key} from the dictionary.
Additional arguments must be named and are passed to the stored object during construction.
\item \code{mget(keys, ...)}\cr
(\code{character()}, ...) -> named \code{list()}\cr
Returns objects with keys \code{keys} in a list named with \code{keys}.
Additional arguments must be named and are passed to the stored objects during construction.
\item \code{has(keys)}\cr
\code{character()} -> \code{logical()}\cr
Returns a logical vector with \code{TRUE} at its i-th position if the i-th key exists.
\item \code{keys(pattern = NULL)}\cr
\code{character(1)} -> \code{character()}\cr
Returns all keys which comply to the regular expression \code{pattern}.
If \code{pattern} is \code{NULL} (default), all keys are returned.
\item \code{add(key, value, ..., required_args = character())}\cr
(\code{character(1)}, \code{any}, ..., \code{character()}) -> \code{self}\cr
Adds object \code{value} to the dictionary with key \code{key}, potentially overwriting a previously stored item.
Additional arguments in \code{...} must be named and are used as default arguments for \code{value} during construction.
If the object cannot be constructed without additional arguments, the require argument names should be provided in \code{required_args}.
\item \code{remove(keys)}\cr
\code{character()} -> \code{self}\cr
Removes objects with keys \code{keys} from the dictionary.
\item \code{required_args(key)}\cr
(\code{character(1)}) -> \code{character()}\cr
Returns the names of arguments required to construct the object.
}
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(d)}\cr
\link{Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Converts the dictionary to a \code{\link[data.table:data.table]{data.table::data.table()}}.
}
}

\examples{
d = Dictionary$new()
d$add("a", 1)
d$add("b", 2)
d$keys()
d$get("a")
d$mget(c("a", "b"))
}
\concept{Dictionary}
\keyword{datasets}
