% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_linex.R
\name{linex}
\alias{linex}
\title{Linear-Exponential Loss (per observation)}
\usage{
linex(truth, response, a = -1, b = 1, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{a}{(\code{numeric(1)})\cr
Shape parameter controlling asymmetry.
Negative values penalize overestimation more, positive values penalize underestimation more.
As \code{a} approaches 0, the loss resembles squared error loss. Default is \code{-1}.}

\item{b}{(\code{numeric(1)})\cr
Positive scaling factor for the loss. Larger values increase the loss magnitude.
Default is \code{1}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(length(truth))}.
}
\description{
Measure to compare true observed response with predicted response in regression tasks.

Note that this is an unaggregated measure, returning the losses per observation.
}
\details{
The Linear-Exponential Loss is defined as \deqn{
  b (\exp (t_i - r_i) - a (t_i - r_i) - 1),
}{
}
where \eqn{a \neq 0, b > 0}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range (per observation): \eqn{[0, \infty)}{[0, Inf)}
\item Minimize (per observation): \code{TRUE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
linex(truth, response)
}
\references{
Varian, R. H (1975).
\dQuote{A Bayesian Approach to Real Estate Assessment.}
In Fienberg SE, Zellner A (eds.), \emph{Studies in Bayesian Econometrics and Statistics: In Honor of Leonard J. Savage}, 195--208.
North-Holland, Amsterdam.
}
\seealso{
Other Regression Measures: 
\code{\link{ae}()},
\code{\link{ape}()},
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{pinball}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{se}()},
\code{\link{sle}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
