% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_tpr.R
\name{tpr}
\alias{tpr}
\alias{recall}
\alias{sensitivity}
\title{True Positive Rate}
\usage{
tpr(truth, response, positive, na_value = NaN, ...)

recall(truth, response, positive, na_value = NaN, ...)

sensitivity(truth, response, positive, na_value = NaN, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{response}{(\code{factor()})\cr
Predicted response labels.
Must have the exactly same two levels and the same length as \code{truth}.}

\item{positive}{(\verb{character(1))}\cr
Name of the positive class.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
labels
in binary classification tasks.
}
\details{
The True Positive Rate is defined as \deqn{
  \frac{\mathrm{TP}}{\mathrm{TP} + \mathrm{FN}}.
}{
  TP / (TP + FN).
}
Also know as "recall" or "sensitivity".

This measure is undefined if TP + FN = 0.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
tpr(truth, response, positive = "a")
}
\references{
\url{https://en.wikipedia.org/wiki/Template:DiagnosticTesting_Diagram}

Goutte C, Gaussier E (2005).
\dQuote{A Probabilistic Interpretation of Precision,  Recall and F-Score,  with Implication for Evaluation.}
In \emph{Lecture Notes in Computer Science}, 345--359.
\doi{10.1007/978-3-540-31865-1_25}.
}
\seealso{
Other Binary Classification Measures: 
\code{\link{auc}()},
\code{\link{bbrier}()},
\code{\link{dor}()},
\code{\link{fbeta}()},
\code{\link{fdr}()},
\code{\link{fnr}()},
\code{\link{fn}()},
\code{\link{fomr}()},
\code{\link{fpr}()},
\code{\link{fp}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{prauc}()},
\code{\link{tnr}()},
\code{\link{tn}()},
\code{\link{tp}()}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
