% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_mbrier.R
\name{mbrier}
\alias{mbrier}
\title{Multiclass Brier Score}
\usage{
mbrier(truth, prob, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{prob}{:: \code{matrix()}\cr
Matrix of predicted probabilities, each column is a vector of probabilities for a
specific class label.
Columns must be named with levels of \code{truth}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Brier score for multi-class classification problems with \eqn{r} labels defined as \deqn{
   \frac{1}{n} \sum_{i=1}^n \sum_{j=1}^r (I_{ij} - p_{ij})^2.
}{
}
\eqn{I_{ij}}{I_ij} is 1 if observation \eqn{i} has true label \eqn{j}, and 0 otherwise.

Note that there also is the more common definition of the Brier score for binary
classification problems in \code{\link[=bbrier]{bbrier()}}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 2]}{[0, 2]}
\item Minimize: \code{TRUE}
\item Required prediction: \code{prob}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
prob = matrix(runif(3 * 10), ncol = 3)
colnames(prob) = levels(truth)
mbrier(truth, prob)
}
\references{
\cite{brier_1950}
}
\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{logloss}()}
}
\concept{Classification Measures}
\concept{classification_measure}
