% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurrogateLearnerCollection.R
\name{SurrogateLearnerCollection}
\alias{SurrogateLearnerCollection}
\title{Surrogate Model Containing Multiple Learners}
\description{
Surrogate model containing multiple \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}.
The \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} are fit on the target variables as indicated via \code{cols_y}.
Note that redundant \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} must be deep clones.
}
\section{Parameters}{

\describe{
\item{\code{assert_insample_perf}}{\code{logical(1)}\cr
Should the insample performance of the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} be asserted after updating the surrogate?
If the assertion fails (i.e., the insample performance based on the \code{perf_measure} does not meet the
\code{perf_threshold}), an error is thrown.
Default is \code{FALSE}.
}
\item{\code{perf_measure}}{List of \link[mlr3:MeasureRegr]{mlr3::MeasureRegr}\cr
Performance measures which should be use to assert the insample performance of the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}.
Only relevant if \code{assert_insample_perf = TRUE}.
Default is \link[mlr3:mlr_measures_regr.rsq]{mlr3::mlr_measures_regr.rsq} for each learner.
}
\item{\code{perf_threshold}}{List of \code{numeric(1)}\cr
Thresholds the insample performance of the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} should be asserted against.
Only relevant if \code{assert_insample_perf = TRUE}.
Default is \code{0} for each learner.
}
\item{\code{catch_errors}}{\code{logical(1)}\cr
Should errors during updating the surrogate be caught and propagated to the \code{loop_function} which can then handle
the failed acquisition function optimization (as a result of the failed surrogate) appropriately by, e.g., proposing a randomly sampled point for evaluation?
Default is \code{TRUE}.
}
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud") &
    requireNamespace("ranger")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)

  fun = function(xs) {
    list(y1 = xs$x^2, y2 = (xs$x - 2) ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y1 = p_dbl(tags = "minimize"), y2 = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchMultiCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))
  xdt = generate_design_random(instance$search_space, n = 4)$data

  instance$eval_batch(xdt)

  learner1 = default_gp()

  learner2 = default_rf()

  surrogate = srlrn(list(learner1, learner2), archive = instance$archive)

  surrogate$update()

  surrogate$learner

  surrogate$learner[["y2"]]$model
}
}
\section{Super class}{
\code{\link[mlr3mbo:Surrogate]{mlr3mbo::Surrogate}} -> \code{SurrogateLearnerCollection}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{print_id}}{(\code{character})\cr
Id used when printing.}

\item{\code{n_learner}}{(\code{integer(1)})\cr
Returns the number of surrogate models.}

\item{\code{assert_insample_perf}}{(\code{numeric()})\cr
Asserts whether the current insample performance meets the performance threshold.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{feature_types}}{(\code{character()})\cr
Stores the feature types the surrogate can handle, e.g. \code{"logical"}, \code{"numeric"}, or \code{"factor"}.
A complete list of candidate feature types, grouped by task type, is stored in \code{\link[mlr3:mlr_reflections]{mlr_reflections$task_feature_types}}.}

\item{\code{properties}}{(\code{character()})\cr
Stores a set of properties/capabilities the surrogate has.
A complete list of candidate properties, grouped by task type, is stored in \code{\link[mlr3:mlr_reflections]{mlr_reflections$learner_properties}}.}

\item{\code{predict_type}}{(\code{character(1)})\cr
Retrieves the currently active predict type, e.g. \code{"response"}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SurrogateLearnerCollection-new}{\code{SurrogateLearnerCollection$new()}}
\item \href{#method-SurrogateLearnerCollection-predict}{\code{SurrogateLearnerCollection$predict()}}
\item \href{#method-SurrogateLearnerCollection-clone}{\code{SurrogateLearnerCollection$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="Surrogate" data-id="format"><a href='../../mlr3mbo/html/Surrogate.html#method-Surrogate-format'><code>mlr3mbo::Surrogate$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="Surrogate" data-id="print"><a href='../../mlr3mbo/html/Surrogate.html#method-Surrogate-print'><code>mlr3mbo::Surrogate$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="Surrogate" data-id="update"><a href='../../mlr3mbo/html/Surrogate.html#method-Surrogate-update'><code>mlr3mbo::Surrogate$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SurrogateLearnerCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-SurrogateLearnerCollection-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SurrogateLearnerCollection$new(
  learners,
  archive = NULL,
  cols_x = NULL,
  cols_y = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learners}}{(list of \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}).}

\item{\code{archive}}{(\link[bbotk:Archive]{bbotk::Archive} | \code{NULL})\cr
\link[bbotk:Archive]{bbotk::Archive} of the \link[bbotk:OptimInstance]{bbotk::OptimInstance}.}

\item{\code{cols_x}}{(\code{character()} | \code{NULL})\cr
Column id's of variables that should be used as features.
By default, automatically inferred based on the archive.}

\item{\code{cols_y}}{(\code{character()} | \code{NULL})\cr
Column id's of variables that should be used as targets.
By default, automatically inferred based on the archive.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SurrogateLearnerCollection-predict"></a>}}
\if{latex}{\out{\hypertarget{method-SurrogateLearnerCollection-predict}{}}}
\subsection{Method \code{predict()}}{
Predict mean response and standard error.
Returns a named list of data.tables.
Each contains the mean response and standard error for one \code{col_y}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SurrogateLearnerCollection$predict(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
New data. One row per observation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of \code{\link[data.table:data.table]{data.table::data.table()}}s with the columns \code{mean} and \code{se}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SurrogateLearnerCollection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SurrogateLearnerCollection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SurrogateLearnerCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
