% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureCiNestedCV.R
\name{mlr_measures_ci.ncv}
\alias{mlr_measures_ci.ncv}
\alias{MeasureCiNestedCV}
\title{Nested CV CI}
\description{
Confidence Intervals based on \code{\link{ResamplingNestedCV}}, including bias-correction.
This inference method can only be applied to decomposable losses.
}
\section{Point Estimation}{

The point estimate uses a bias correction term as described in Bates et al. (2024).
Therefore, the results of directly applying a measure \verb{$aggregate(msr(<key>))} will be different
from the point estimate of \verb{$aggregate(msr("ci", <key>))}, where the point estimate is obtained
by averaging over the outer CV results.
}

\section{Parameters}{

Those from \code{\link{MeasureAbstractCi}}, as well as:
\itemize{
\item \code{bias} :: \code{logical(1)}\cr
Whether to do bias correction. This is initialized to \code{TRUE}.
If \code{FALSE}, the outer iterations are used for the point estimate
and no bias correction is applied.
}
}

\examples{
ci_ncv = msr("ci.ncv", "classif.acc")
ci_ncv
}
\references{
Bates, Stephen, Hastie, Trevor, Tibshirani, Robert (2024).
\dQuote{Cross-validation: what does it estimate and how well does it do it?}
\emph{Journal of the American Statistical Association}, \bold{119}(546), 1434--1445.
}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3inferr:MeasureAbstractCi]{mlr3inferr::MeasureAbstractCi}} -> \code{MeasureCiNestedCV}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureCiNestedCV-new}{\code{MeasureCiNestedCV$new()}}
\item \href{#method-MeasureCiNestedCV-clone}{\code{MeasureCiNestedCV$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3inferr" data-topic="MeasureAbstractCi" data-id="aggregate"><a href='../../mlr3inferr/html/MeasureAbstractCi.html#method-MeasureAbstractCi-aggregate'><code>mlr3inferr::MeasureAbstractCi$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureCiNestedCV-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureCiNestedCV-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCiNestedCV$new(measure)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{(\code{\link[mlr3:Measure]{Measure}} or \code{character(1)})\cr
A measure of ID of a measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureCiNestedCV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureCiNestedCV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCiNestedCV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
