% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_fselector.R
\name{auto_fselector}
\alias{auto_fselector}
\title{Syntactic Sugar for Automatic Feature Selection}
\usage{
auto_fselector(
  method,
  learner,
  resampling,
  measure,
  term_evals = NULL,
  term_time = NULL,
  ...
)
}
\arguments{
\item{method}{(\code{character(1)} | \link{FSelector})\cr
Key to retrieve fselector from \link{mlr_fselectors} dictionary or \link{FSelector} object.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner}).}

\item{resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Uninstantiated resamplings are instantiated during construction
so that all configurations are evaluated on the same data splits.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize.}

\item{term_evals}{(\code{integer(1)})\cr
Number of allowed evaluations.}

\item{term_time}{(\code{integer(1)})\cr
Maximum allowed time in seconds.}

\item{...}{(named \code{list()})\cr
Named arguments to be set as parameters of the fselector.}
}
\value{
\link{AutoFSelector}
}
\description{
Function to create an \link{AutoFSelector} object.
}
\examples{
at = auto_fselector(
  method = "random_search",
  learner = lrn("classif.rpart"),
  resampling = rsmp ("holdout"),
  measure = msr("classif.ce"),
  term_evals = 4)

at$train(tsk("pima"))
}
