% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorGeneticSearch.R
\name{FSelectorGeneticSearch}
\alias{FSelectorGeneticSearch}
\title{Feature Selection via Genetic Search}
\description{
\code{FSelectorGeneticSearch} class that implements an Genetic Search. Calls
\code{\link[genalg:rbga.bin]{genalg::rbga.bin()}} from package \CRANpkg{genalg}.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_fselectors} or with the associated sugar function \code{\link[=fs]{fs()}}:\preformatted{mlr_fselectors$get("genetic_search")
fs("genetic_search")
}
}

\section{Parameters}{

\describe{
\item{\code{suggestions}}{\code{list()}}
\item{\code{popSize}}{\code{integer(1)}}
\item{\code{mutationChance}}{\code{numeric(1)}}
\item{\code{elitism}}{\code{integer(1)}}
\item{\code{zeroToOneRatio}}{\code{integer(1)}}
\item{\code{iters}}{\code{integer(1)}}
}

For the meaning of the control parameters, see \code{\link[genalg:rbga.bin]{genalg::rbga.bin()}}.
\code{\link[genalg:rbga.bin]{genalg::rbga.bin()}} internally terminates after \code{iters} iteration. We set
\code{ìters = 100000}  to allow the termination via our terminators. If more
iterations are needed, set \code{ìters} to a higher value in the parameter set.
}

\examples{
library(mlr3)

terminator = trm("evals", n_evals = 5)

instance = FSelectInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = terminator
)

fselector = fs("genetic_search", popSize = 10L)
\donttest{
# Modifies the instance by reference
fselector$optimize(instance)

# Returns best scoring evaluation
instance$result

# Allows access of data.table of full path of all evaluations
as.data.table(instance$archive)}
}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorGeneticSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FSelectorGeneticSearch$new()}}
\item \href{#method-clone}{\code{FSelectorGeneticSearch$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format">}\href{../../mlr3fselect/html/FSelector.html#method-format}{\code{mlr3fselect::FSelector$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize">}\href{../../mlr3fselect/html/FSelector.html#method-optimize}{\code{mlr3fselect::FSelector$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print">}\href{../../mlr3fselect/html/FSelector.html#method-print}{\code{mlr3fselect::FSelector$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorGeneticSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorGeneticSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
