% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorSequential.R
\name{FSelectorSequential}
\alias{FSelectorSequential}
\title{Feature Selection via Sequential Selection}
\description{
\code{FSelectorSequential} class that implements sequential feature selection. The
sequential forward selection (\code{strategy = fsf}) extends the feature set in
each step with the feature that increases the models performance the most.
The sequential backward selection (\code{strategy = fsb}) starts with the complete
future set and removes in each step the feature that decreases the models
performance the least.
}
\note{
Feature sets are evaluated in batches, where each batch is one step in the
sequential feature selection.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_fselectors} or with the associated sugar function \code{\link[=fs]{fs()}}:\preformatted{mlr_fselectors$get("sequential")
fs("sequential")
}
}

\section{Parameters}{

\describe{
\item{\code{max_features}}{\code{integer(1)}\cr
Maximum number of features. By default, number of features in \link[mlr3:Task]{mlr3::Task}.}
\item{\code{strategy}}{\code{character(1)}\cr
Search method \code{sfs} (forward search) or \code{sbs} (backward search).}
}
}

\examples{
library(mlr3)

terminator = trm("evals", n_evals = 5)

instance = FSelectInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = terminator
)

fselector = fs("sequential")
\donttest{
# Modifies the instance by reference
fselector$optimize(instance)

# Returns best scoring evaluation
instance$result

# Allows access of data.table of full path of all evaluations
as.data.table(instance$archive)}
}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorSequential}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FSelectorSequential$new()}}
\item \href{#method-optimization_path}{\code{FSelectorSequential$optimization_path()}}
\item \href{#method-clone}{\code{FSelectorSequential$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format">}\href{../../mlr3fselect/html/FSelector.html#method-format}{\code{mlr3fselect::FSelector$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize">}\href{../../mlr3fselect/html/FSelector.html#method-optimize}{\code{mlr3fselect::FSelector$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print">}\href{../../mlr3fselect/html/FSelector.html#method-print}{\code{mlr3fselect::FSelector$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.`
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorSequential$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimization_path"></a>}}
\if{latex}{\out{\hypertarget{method-optimization_path}{}}}
\subsection{Method \code{optimization_path()}}{
Returns the optimization path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorSequential$optimization_path(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{FSelectInstanceSingleCrit})\cr
Instance optimized with \link{FSelectorSequential}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorSequential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
