% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendDuckDB.R
\name{DataBackendDuckDB}
\alias{DataBackendDuckDB}
\title{DataBackend for DuckDB}
\description{
A \link[mlr3:DataBackend]{mlr3::DataBackend} for \CRANpkg{duckdb}.
Can be easily constructed with \code{\link[=as_duckdb_backend]{as_duckdb_backend()}}.
}
\seealso{
\url{https://duckdb.org/}
}
\section{Super class}{
\code{\link[mlr3:DataBackend]{mlr3::DataBackend}} -> \code{DataBackendDuckDB}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{levels}}{(named \code{list()})\cr
List (named with column names) of factor levels as \code{character()}.
Used to auto-convert character columns to factor variables.}

\item{\code{connector}}{(\verb{function()})\cr
Function which is called to re-connect in case the connection became invalid.}

\item{\code{table}}{(\code{character(1)})\cr
Data base table or view to operate on.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{table_info}}{(\code{data.frame()})\cr
Data frame as returned by pragma \code{table_info()}.}

\item{\code{rownames}}{(\code{integer()})\cr
Returns vector of all distinct row identifiers, i.e. the contents of the primary key column.}

\item{\code{colnames}}{(\code{character()})\cr
Returns vector of all column names, including the primary key column.}

\item{\code{nrow}}{(\code{integer(1)})\cr
Number of rows (observations).}

\item{\code{ncol}}{(\code{integer(1)})\cr
Number of columns (variables), including the primary key column.}

\item{\code{valid}}{(\code{logical(1)})\cr
Returns \code{NA} if the data does not inherits from \code{"tbl_sql"} (i.e., it is not a real SQL data base).
Returns the result of \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} otherwise.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataBackendDuckDB-new}{\code{DataBackendDuckDB$new()}}
\item \href{#method-DataBackendDuckDB-data}{\code{DataBackendDuckDB$data()}}
\item \href{#method-DataBackendDuckDB-head}{\code{DataBackendDuckDB$head()}}
\item \href{#method-DataBackendDuckDB-distinct}{\code{DataBackendDuckDB$distinct()}}
\item \href{#method-DataBackendDuckDB-missings}{\code{DataBackendDuckDB$missings()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="DataBackend" data-id="format"><a href='../../mlr3/html/DataBackend.html#method-DataBackend-format'><code>mlr3::DataBackend$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="DataBackend" data-id="print"><a href='../../mlr3/html/DataBackend.html#method-DataBackend-print'><code>mlr3::DataBackend$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDuckDB-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDuckDB-new}{}}}
\subsection{Method \code{new()}}{
Creates a backend for a \code{\link[duckdb:duckdb]{duckdb::duckdb()}} database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDuckDB$new(
  data,
  table,
  primary_key,
  strings_as_factors = TRUE,
  connector = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(connection)\cr
A connection created with \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.
If constructed manually (and not via the helper function \code{\link[=as_duckdb_backend]{as_duckdb_backend()}},
make sure that there exists an (unique) index for the key column.}

\item{\code{table}}{(\code{character(1)})\cr
Table or view to operate on.}

\item{\code{primary_key}}{(\code{character(1)})\cr
Name of the primary key column.}

\item{\code{strings_as_factors}}{(\code{logical(1)} || \code{character()})\cr
Either a character vector of column names to convert to factors, or a single logical flag:
if \code{FALSE}, no column will be converted, if \code{TRUE} all string columns (except the primary key).
For conversion, the backend is queried for distinct values of the respective columns
on construction and their levels are stored in \verb{$levels}.}

\item{\code{connector}}{(function()\verb{)\\cr If not }NULL`, a function which re-connects to the database in case the connection has become invalid.
Database connections can become invalid due to timeouts or if the backend is serialized
to the file system and then de-serialized again.
This round trip is often performed for parallelization, e.g. to send the objects to remote workers.
\code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} is called to validate the connection.
The function must return just the connection, not a \code{\link[dplyr:tbl]{dplyr::tbl()}} object!
Note that this this function is serialized together with the backend, including
possible sensitive information such as login credentials.
These can be retrieved from the stored \link[mlr3:DataBackend]{mlr3::DataBackend}/\link[mlr3:Task]{mlr3::Task}.
To protect your credentials, it is recommended to use the \CRANpkg{secret} package.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDuckDB-data"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDuckDB-data}{}}}
\subsection{Method \code{data()}}{
Returns a slice of the data.

The rows must be addressed as vector of primary key values, columns must be referred to via column names.
Queries for rows with no matching row id and queries for columns with no matching
column name are silently ignored.
Rows are guaranteed to be returned in the same order as \code{rows}, columns may be returned in an arbitrary order.
Duplicated row ids result in duplicated rows, duplicated column names lead to an exception.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDuckDB$data(rows, cols, data_format = "data.table")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{data_format}}{(\code{character(1)})\cr
Desired data format, e.g. \code{"data.table"} or \code{"Matrix"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDuckDB-head"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDuckDB-head}{}}}
\subsection{Method \code{head()}}{
Retrieve the first \code{n} rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDuckDB$head(n = 6L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} of the first \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDuckDB-distinct"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDuckDB-distinct}{}}}
\subsection{Method \code{distinct()}}{
Returns a named list of vectors of distinct values for each column
specified. If \code{na_rm} is \code{TRUE}, missing values are removed from the
returned vectors of distinct values. Non-existing rows and columns are
silently ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDuckDB$distinct(rows, cols, na_rm = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{na_rm}}{\code{logical(1)}\cr
Whether to remove NAs or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{list()} of distinct values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDuckDB-missings"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDuckDB-missings}{}}}
\subsection{Method \code{missings()}}{
Returns the number of missing values per column in the specified slice
of data. Non-existing rows and columns are silently ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDuckDB$missings(rows, cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Total of missing values per column (named \code{numeric()}).
}
}
}
