% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_converters.R
\name{convert_task}
\alias{convert_task}
\alias{as_task_classif}
\alias{as_task_classif.TaskRegr}
\alias{as_task_classif.data.frame}
\alias{as_task_regr}
\alias{as_task_regr.TaskClassif}
\alias{as_task_regr.data.frame}
\title{Convert a Task from One Type to Another}
\usage{
convert_task(
  intask,
  target = NULL,
  new_type = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE
)

as_task_classif(x, target = NULL, ...)

\method{as_task_classif}{TaskRegr}(
  x,
  target = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE,
  ...
)

\method{as_task_classif}{data.frame}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  positive = NULL,
  ...
)

as_task_regr(x, target = NULL, ...)

\method{as_task_regr}{TaskClassif}(
  x,
  target = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE,
  ...
)

\method{as_task_regr}{data.frame}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  positive = NULL,
  ...
)
}
\arguments{
\item{intask}{(\link{Task})\cr
A \link{Task} to be converted.}

\item{target}{(\code{character(1)})\cr
New target to be set, must be a column in the \code{intask} data.
If \code{NULL}, no new target is set, and task is converted as-is.}

\item{new_type}{(\code{character(1)})\cr
The new task type. Must be in \code{\link[=mlr_reflections]{mlr_reflections$task_types}}].
If \code{NULL} (default), a new task with the same task_type is created.}

\item{drop_original_target}{(\code{logical(1)})\cr
If \code{FALSE} (default), the original target is added as a feature.
Otherwise the original target is dropped.}

\item{drop_levels}{(\code{logical(1)})\cr
If \code{TRUE} (default), unused levels of the new target variable are dropped.}

\item{x}{(\code{any})\cr
Object to convert.}

\item{...}{(\code{any})\cr
Additional arguments, currently ignored.}

\item{id}{(\code{character(1)})\cr
Id for the new task.}

\item{positive}{(\code{character(1)})\cr
Level of the positive class. See \link{TaskClassif}.}
}
\value{
\link{Task} of requested type.
}
\description{
The task's target is replaced by a different column from the data.
}
