% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskGenerator2DNormals.R
\name{mlr_task_generators_2dnormals}
\alias{mlr_task_generators_2dnormals}
\alias{TaskGenerator2DNormals}
\title{2D Normals Classification Task Generator}
\description{
A \link{TaskGenerator} for the 2d normals task in \code{\link[mlbench:mlbench.2dnormals]{mlbench::mlbench.2dnormals()}}.
}
\section{Dictionary}{

This \link{TaskGenerator} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_task_generators} or with the associated sugar function \code{\link[=tgen]{tgen()}}:\preformatted{mlr_task_generators$get("2dnormals")
tgen("2dnormals")
}
}

\examples{
generator = tgen("2dnormals")
plot(generator, n = 200)

task = generator$generate(200)
str(task$data())
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=TaskGenerator]{TaskGenerators}: \link{mlr_task_generators}

\code{as.data.table(mlr_resamplings)} for a complete table of all (also dynamically created) \link{TaskGenerator} implementations.

Other TaskGenerator: 
\code{\link{TaskGenerator}},
\code{\link{mlr_task_generators_cassini}},
\code{\link{mlr_task_generators_circle}},
\code{\link{mlr_task_generators_friedman1}},
\code{\link{mlr_task_generators_moons}},
\code{\link{mlr_task_generators_simplex}},
\code{\link{mlr_task_generators_smiley}},
\code{\link{mlr_task_generators_spirals}},
\code{\link{mlr_task_generators_xor}},
\code{\link{mlr_task_generators}}
}
\concept{TaskGenerator}
\section{Super class}{
\code{\link[mlr3:TaskGenerator]{mlr3::TaskGenerator}} -> \code{TaskGenerator2DNormals}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TaskGenerator2DNormals$new()}}
\item \href{#method-plot}{\code{TaskGenerator2DNormals$plot()}}
\item \href{#method-clone}{\code{TaskGenerator2DNormals$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="format">}\href{../../mlr3/html/TaskGenerator.html#method-format}{\code{mlr3::TaskGenerator$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="generate">}\href{../../mlr3/html/TaskGenerator.html#method-generate}{\code{mlr3::TaskGenerator$generate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="print">}\href{../../mlr3/html/TaskGenerator.html#method-print}{\code{mlr3::TaskGenerator$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGenerator2DNormals$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Creates a simple plot of generated data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGenerator2DNormals$plot(n = 200, pch = 19L, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of samples to draw for the plot. Default is 200.}

\item{\code{pch}}{(\code{integer(1)})\cr
Point char. Passed to \code{\link[=plot]{plot()}}.}

\item{\code{...}}{(any)\cr
Additional arguments passed to \code{\link[=plot]{plot()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGenerator2DNormals$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
