% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Manually Partition into Training, Test and Validation Set}
\usage{
partition(task, ratio = 0.67)
}
\arguments{
\item{task}{(\link{Task})\cr
Task to operate on.}

\item{ratio}{(\code{numeric()})\cr
Ratio of observations to put into the training set.
If a 2 element vector is provided, the first element is the ratio for the training set, the second element is the ratio for the test set.
The validation set will contain the remaining observations.}
}
\description{
Creates a split of the row ids of a \link{Task} into a training and a test set, and optionally a validation set.
}
\examples{
# regression task partitioned into training and test set
task = tsk("boston_housing")
split = partition(task, ratio = 0.5)
data = data.frame(
  y = c(task$truth(split$train), task$truth(split$test)),
  split = rep(c("train", "predict"), lengths(split[c("train", "test")]))
)
boxplot(y ~ split, data = data)

# classification task partitioned into training, test and validation set
task = tsk("pima")
split = partition(task, c(0.66, 0.14))
}
