% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Resample a Learner on a Task}
\usage{
resample(
  task,
  learner,
  resampling,
  store_models = FALSE,
  store_backends = TRUE
)
}
\arguments{
\item{task}{(\link{Task}).}

\item{learner}{(\link{Learner}).}

\item{resampling}{(\link{Resampling}).}

\item{store_models}{(\code{logical(1)})\cr
Keep the fitted model after the test set has been predicted?
Set to \code{TRUE} if you want to further analyse the models or want to
extract information like variable importance.}

\item{store_backends}{(\code{logical(1)})\cr
Keep the \link{DataBackend} of the \link{Task} in the \link{ResampleResult}?
Set to \code{TRUE} if your performance measures require a \link{Task},
or to analyse results more conveniently.
Set to \code{FALSE} to reduce the file size and memory footprint
after serialization.
The current default is \code{TRUE}, but this eventually will be changed
in a future release.}
}
\value{
\link{ResampleResult}.
}
\description{
Runs a resampling (possibly in parallel):
Repeatedly apply \link{Learner} \code{learner} on a training set of \link{Task} \code{task} to train a model,
then use the trained model to predict observations of a test set.
Training and test sets are defined by the \link{Resampling} \code{resampling}.
}
\note{
The fitted models are discarded after the predictions have been computed in order to reduce memory consumption.
If you need access to the models for later analysis, set \code{store_models} to \code{TRUE}.
}
\section{Parallelization}{


This function can be parallelized with the \CRANpkg{future} package.
One job is one resampling iteration, and all jobs are send to an apply function
from \CRANpkg{future.apply} in a single batch.
To select a parallel backend, use \code{\link[future:plan]{future::plan()}}.
}

\section{Progress Bars}{

This function supports progress bars via the package \CRANpkg{progressr}.
Simply wrap the function in \code{\link[progressr:with_progress]{progressr::with_progress()}} to enable them.
We recommend to use package \CRANpkg{progress} as backend; enable with
\code{progressr::handlers("progress")}.
}

\section{Logging}{


The \CRANpkg{mlr3} uses the \CRANpkg{lgr} package for logging.
\CRANpkg{lgr} supports multiple log levels which can be queried with
\code{getOption("lgr.log_levels")}.

To suppress output and reduce verbosity, you can lower the log from the
default level \code{"info"} to \code{"warn"}:\preformatted{lgr::get_logger("mlr3")$set_threshold("warn")
}

To get additional log output for debugging, increase the log level to \code{"debug"}
or \code{"trace"}:\preformatted{lgr::get_logger("mlr3")$set_threshold("debug")
}

To log to a file or a data base, see the documentation of \link[lgr:lgr-package]{lgr::lgr-package}.
}

\examples{
task = tsk("penguins")
learner = lrn("classif.rpart")
resampling = rsmp("cv")

# Explicitly instantiate the resampling for this task for reproduciblity
set.seed(123)
resampling$instantiate(task)

rr = resample(task, learner, resampling)
print(rr)

# Retrieve performance
rr$score(msr("classif.ce"))
rr$aggregate(msr("classif.ce"))

# merged prediction objects of all resampling iterations
pred = rr$prediction()
pred$confusion

# Repeat resampling with featureless learner
rr_featureless = resample(task, lrn("classif.featureless"), resampling)

# Convert results to BenchmarkResult, then combine them
bmr1 = as_benchmark_result(rr)
bmr2 = as_benchmark_result(rr_featureless)
print(bmr1$combine(bmr2))
}
