% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSensRegrWrapper.R
\name{makeCostSensRegrWrapper}
\alias{CostSensRegrModel}
\alias{CostSensRegrWrapper}
\alias{makeCostSensRegrWrapper}
\title{Wraps a regression learner for use in cost-sensitive learning.}
\usage{
makeCostSensRegrWrapper(learner)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The regression learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Creates a wrapper, which can be used like any other learner object.
Models can easily be accessed via \code{\link{getLearnerModel}}.

For each class in the task, an individual regression model is fitted for the costs of that class.
During prediction, the class with the lowest predicted costs is selected.
}
\seealso{
Other costsens: \code{\link{makeClassifTask}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensWeightedPairsWrapper}}

Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}

