% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePartialPrediction.R
\name{generatePartialPredictionData}
\alias{generatePartialPredictionData}
\title{Generate partial predictions}
\usage{
generatePartialPredictionData(obj, input, features, interaction = FALSE,
  derivative = FALSE, individual = FALSE, center = NULL, fun = mean,
  bounds = c(qnorm(0.025), qnorm(0.975)), resample = "none", fmin, fmax,
  gridsize = 10L, ...)
}
\arguments{
\item{obj}{[\code{\link{WrappedModel}}]\cr
Result of \code{\link{train}}.}

\item{input}{[\code{data.frame} | \code{\link{Task}}]\cr
Input data.}

\item{features}{[\code{character}]\cr
A vector of feature names contained in the training data.
If not specified all features in the \code{input} will be used.}

\item{interaction}{[\code{logical(1)}]\cr
Whether the \code{features} should be interacted or not. If \code{TRUE} then the Cartesian product of the
prediction grid for each feature is taken, and the partial prediction at each unique combination of
values of the features is estimated. Note that if the length of \code{features} is greater than two,
\code{\link{plotPartialPrediction}} and \code{\link{plotPartialPredictionGGVIS}} cannot be used.
If \code{FALSE} each feature is considered separately. In this case \code{features} can be much longer
than two.
Default is \code{FALSE}.}

\item{derivative}{[\code{logical(1)}]\cr
Whether or not the partial derivative of the learned function with respect to the features should be
estimated. If \code{TRUE} \code{interaction} must be \code{FALSE}. The partial derivative of individual
observations may be estimated. Note that computation time increases as the learned prediction function
is evaluated at \code{gridsize} points * the number of points required to estimate the partial derivative.
Additional arguments may be passed to \code{\link[numDeriv]{grad}} (for regression or survival tasks) or
\code{\link[numDeriv]{jacobian}} (for classification tasks). Note that functions which are not smooth may
result in estimated derivatives of 0 (for points where the function does not change within +/- epsilon)
or estimates trending towards +/- infinity (at discontinuities).
Default is \code{FALSE}.}

\item{individual}{[\code{logical(1)}]\cr
Whether to plot the individual conditional expectation curves rather than the aggregated curve, i.e.,
rather than aggregating (using \code{fun}) the partial predictions of \code{features}, plot the
partial predictions of all observations in \code{data} across all values of the \code{features}.
The algorithm is developed in Goldstein, Kapelner, Bleich, and Pitkin (2015).
Default is \code{FALSE}.}

\item{center}{[\code{list}]\cr
A named list containing the fixed values of the \code{features}
used to calculate an individual partial prediction which is then
subtracted from each individual partial prediction made across the prediction grid created for the
\code{features}: centering the individual partial prediction lines to make them more interpretable.
This argument is ignored if \code{individual != TRUE}.
Default is \code{NULL}.}

\item{fun}{[\code{function}]\cr
For regression, a function that accepts a numeric vector and returns either a single number
such as a measure of location such as the mean, or three numbers, which give a lower bound,
a measure of location, and an upper bound. Note if three numbers are returned they must be
in this order. For classification with \code{predict.type = "prob"} the function must accept
a numeric matrix with the number of columns equal to the number of class levels of the target.
For classification with \code{predict.type = "response"} (the default) the function must accept
a character vector and output a numeric vector with length equal to the number of classes in the
target feature.
The default is the mean, unless \code{obj} is classification with \code{predict.type = "response"}
in which case the default is the proportion of observations predicted to be in each class.}

\item{bounds}{[\code{numeric(2)}]\cr
The value (lower, upper) the estimated standard error is multiplied by to estimate the bound on a
confidence region for a partial prediction. Ignored if \code{predict.type != "se"} for the learner.
Default is the 2.5 and 97.5 quantiles (-1.96, 1.96) of the Gaussian distribution.}

\item{resample}{[\code{character(1)}]\cr
Defines how the prediction grid for each feature is created. If \dQuote{bootstrap} then
values are sampled with replacement from the training data. If \dQuote{subsample} then
values are sampled without replacement from the training data. If \dQuote{none} an evenly spaced
grid between either the empirical minimum and maximum, or the minimum and maximum defined by
\code{fmin} and \code{fmax}, is created.
Default is \dQuote{none}.}

\item{fmin}{[\code{numeric}]\cr
The minimum value that each element of \code{features} can take.
This argument is only applicable if \code{resample = NULL} and when the empirical minimum is higher
than the theoretical minimum for a given feature. This only applies to numeric features and a
\code{NA} should be inserted into the vector if the corresponding feature is a factor.
Default is the empirical minimum of each numeric feature and NA for factor features.}

\item{fmax}{[\code{numeric}]\cr
The maximum value that each element of \code{features} can take.
This argument is only applicable if \code{resample = "none"} and when the empirical maximum is lower
than the theoretical maximum for a given feature. This only applies to numeric features and a
\code{NA} should be inserted into the vector if the corresponding feature is a factor.
Default is the empirical maximum of each numeric feature and NA for factor features.}

\item{gridsize}{[\code{integer(1)}]\cr
The length of the prediction grid created for each feature.
If \code{resample = "bootstrap"} or \code{resample = "subsample"} then this defines
the number of (possibly non-unique) values resampled. If \code{resample = NULL} it defines the
length of the evenly spaced grid created.}

\item{...}{additional arguments to be passed to \code{\link{predict}}.}
}
\value{
[\code{PartialPredictionData}], A named list, which contains the partial predictions,
  input data, target, features, task description, and other arguments controlling the type of
  partial predictions made.
}
\description{
Estimate how the learned prediction function is affected by one or more features.
For a learned function f(x) where x is partitioned into x_s and x_c, the partial dependence of
f on x_s can be summarized by averaging over x_c and setting x_s to a range of values of interest,
estimating E_(x_c)(f(x_s, x_c)). The conditional expectation of f at observation i is estimated similarly.
Additionally, partial derivatives of the marginalized function w.r.t. the features can be computed.
}
\examples{
lrn = makeLearner("regr.rpart")
fit = train(lrn, bh.task)
pd = generatePartialPredictionData(fit, bh.task, "lstat")
plotPartialPrediction(pd)

lrn = makeLearner("classif.rpart", predict.type = "prob")
fit = train(lrn, iris.task)
pd = generatePartialPredictionData(fit, iris.task, "Petal.Width")
plotPartialPrediction(pd)
}
\references{
Goldstein, Alex, Adam Kapelner, Justin Bleich, and Emil Pitkin. \dQuote{Peeking inside the black box: Visualizing statistical learning with plots of individual conditional expectation.} Journal of Computational and Graphical Statistics. Vol. 24, No. 1 (2015): 44-65.
Friedman, Jerome. \dQuote{Greedy Function Approximation: A Gradient Boosting Machine.} The Annals of Statistics. Vol. 29. No. 5 (2001): 1189-1232.
}
\seealso{
Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generateROCRCurvesData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{getFilterValues}}

Other partial_prediction: \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}}
}

